/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_HTTP_HTTP_SERVLET_RESPONSE_H
#define SERVLET_HTTP_HTTP_SERVLET_RESPONSE_H

#include <string>

#include <servlet/ServletResponse.h>

namespace servlet {
namespace http {

class Cookie;

/** HTTPΥ쥹ݥ󥹤ɽ륯饹Ǥ. */
class HttpServletResponse : virtual public ServletResponse {
public :
    static const int    SC_CONTINUE                        = 100;
    static const int    SC_SWITCHING_PROTOCOLS             = 101;
    static const int    SC_OK                              = 200;
    static const int    SC_CREATED                         = 201;
    static const int    SC_ACCEPTED                        = 202;
    static const int    SC_NON_AUTHORITATIVE_INFORMATION   = 203;
    static const int    SC_NO_CONTENT                      = 204;
    static const int    SC_RESET_CONTENT                   = 205;
    static const int    SC_MOVED_PERMANENTLY               = 301;
    static const int    SC_MOVED_TEMPORARILY               = 302;
    static const int    SC_MULTIPLE_CHOICES                = 303;
    static const int    SC_SEE_OTHER                       = 303;
    static const int    SC_USE_PROXY                       = 305;
    static const int    SC_NOT_MODIFIED                    = 304;
    static const int    SC_BAD_REQUEST                     = 400;
    static const int    SC_UNAUTHORIZED                    = 401;
    static const int    SC_FORBIDDEN                       = 403;
    static const int    SC_NOT_FOUND                       = 404;
    static const int    SC_METHOD_NOT_ALLOWED              = 405;
    static const int    SC_NOT_ACCEPTABLE                  = 406;
    static const int    SC_PROXY_AUTHENTICATION_REQUIRED   = 407;
    static const int    SC_REQUEST_TIMEOUT                 = 408;
    static const int    SC_CONFLICT                        = 409;
    static const int    SC_GONE                            = 410;
    static const int    SC_LENGTH_REQUIRED                 = 411;
    static const int    SC_PRECONDITION_FAILED             = 412;
    static const int    SC_REQUEST_ENTITY_TOO_LARGE        = 413;
    static const int    SC_REQUEST_URI_TOO_LONG            = 414;
    static const int    SC_UNSUPPORTED_MEDIA_TYPE          = 415;
    static const int    SC_EXPECTATION_FAILED              = 417;
    static const int    SC_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    static const int    SC_INTERNAL_SERVER_ERROR           = 500;
    static const int    SC_NOT_IMPLEMENTED                 = 501;
    static const int    SC_BAD_GATEWAY                     = 502;
    static const int    SC_SERVICE_UNAVAILABLE             = 503;
    static const int    SC_GATEWAY_TIMEOUT                 = 504;
    static const int    SC_HTTP_VERSION_NOT_SUPPORTED      = 505;

    /** Destructor. */
    virtual ~HttpServletResponse();

    /**
     * ꤵ줿Cookie쥹ݥ󥹤ɲäޤ.
     */
    virtual void addCookie(const Cookie& c)=0;

    /**
     *  s ǻꤵ줿դͤĥ쥹ݥ󥹥إåɲäޤ.
     */
    virtual void addDateHeader(const std::string& s, long d)=0;

    /**
     *  s ǻꤵ줿ͤĥ쥹ݥ󥹥إåɲäޤ.
     */
    virtual void
    addHeader(const std::string& s, const std::string& v)=0;

    /**
     *  s ǻꤵ줿ͤĥ쥹ݥ󥹥إåɲäޤ.
     */
    virtual void addIntHeader(const std::string& s, int v)=0;

    /**
     *  s ̾ĥإå˥åȤƤ뤫֤ޤ.
     */
    virtual bool containsHeader(const std::string& s)=0;

    /**
     * 侩Ƥޤ.
     */
    virtual std::string encodeRedirectUrl(const std::string& s)=0;

    /**
     * sendRedirect᥽åɤǻȤ褦ˡꤵ줿URL򥨥󥳡ɤޤ.
     */
    virtual std::string encodeRedirectURL(const std::string& s)=0;

    /**
     * 侩Ƥޤ.
     */
    virtual std::string encodeUrl(const std::string& s)=0;

    /**
     * ꤵ줿URLåIDޤ褦˥󥳡ɤޤ.
     */
    virtual std::string encodeURL(const std::string& s)=0;

    /**
     * Хåե򥯥ꥢꤵ줿ơȤäƥ饤Ȥ
     * 顼쥹ݥ󥹤ޤ.
     */
    virtual void sendError(int sc)=0;

    /**
     * Хåե򥯥ꥢꤵ줿ơȤäƥ饤Ȥ
     * 顼쥹ݥ󥹤ޤ.
     */
    virtual void sendError(int sc, const std::string& s)=0;

    /**
     * ꤵ줿쥯URLѤơ饤Ȥ
     * Ūʥ쥯ȥ쥹ݥ󥹤ޤ.
     */
    virtual void sendRedirect(const std::string& s)=0;

    /**
     *  s ǻꤵ줿դͤĥ쥹ݥ󥹥إåꤷޤ.
     */
    virtual void setDateHeader(const std::string& s, long l)=0;

    /**
     *  s ǻꤵ줿ͤĥ쥹ݥ󥹥إåꤷޤ.
     */
    virtual void setHeader(const std::string& s, const std::string& v)=0;

    /**
     *  s ǻꤵ줿ͤĥ쥹ݥ󥹥إåꤷޤ.
     */
    virtual void setIntHeader(const std::string& s, int v)=0;

    /**
     * Υ쥹ݥ󥹤Υơɤꤷޤ.
     */
    virtual void setStatus(int c)=0;
};

} // namespace http
} // namespace servlet

#endif    // SERVLET_HTTP_HTTP_SERVLET_RESPONSE_H
