/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_HTTP_HTTP_SERVLET_REQUEST_H
#define SERVLET_HTTP_HTTP_SERVLET_REQUEST_H

#include <stdexcept>
#include <string>
#include <vector>

#include <sl/java/lang/IllegalArgumentException.h>
#include <sl/java/lang/NumberFormatException.h>
#include <sl/java/util/Enumeration.h>
#include <sl/java/security/Principal.h>
#include <servlet/ServletRequest.h>

namespace servlet {
namespace http {

class HttpSession;
class Cookie;

/**
 * HTTP ΥꥯȤɽ륯饹Ǥ.
 */
class HttpServletRequest : virtual public ServletRequest {
public :

    /** Destructor. */
    virtual ~HttpServletRequest();

    /**
     * ǧڥ֤̾ޤ.
     *
     * @return    String ̾.
     */
    virtual std::string getAuthType()=0;

    /**
     * åΥꥹȤ.
     *
     * @return    åΥꥹ.
     */
    virtual std::vector<Cookie> getCookies()=0;

    /**
     * ꤵ줿ꥯȥإåͤ long ͤȤ֤ޤ
     *
     * @param    s        إå̾.
     * @return        ɸ00:00:00.000 ηв֤ߥä
     *                ɽͤǤ.
     * @throw    IllegalArgumentException    դѴʤإåꤵ줿
     *                                        ꤲޤ.
     */
    virtual long getDateHeader(const std::string &s)
        throw(sl::java::lang::IllegalArgumentException)=0;

    /**
     *  s бإåͤint˥㥹Ȥ֤ޤ.
     *
     * @param    s    إå̾.
     * @return    إå.
     */
    virtual int getIntHeader(const std::string& s)
        throw(sl::java::lang::NumberFormatException)=0;

    /**
     *  s бإå֤ͤޤ.
     *
     * @param    s    إå̾.
     * @return    إå.
     */
    virtual std::string getHeader(const std::string& s)=0;

    /**
     *  s бإå֤ͤޤ.
     *
     * @param    s    إå̾.
     * @return    إå.
     */
    virtual std::vector<std::string> getHeaders(const std::string& s)=0;

    /**
     * إå̾ΥꥹȤ֤ޤ.
     *
     * @return    إå̾Υꥹ.
     */
    virtual sl::java::util::Enumeration getHeaderNames()=0;

    /**
     * ꥯȤΥ᥽åɤ֤ޤ.
     *
     * @return    ᥽å.
     */
    virtual std::string getMethod()=0;

    /**
     * ꥯȤURL˴Ϣդ줿ĥѥ֤ޤ.
     *
     * @return    ѥ.
     */
    virtual std::string getPathInfo()=0;

    /**
     * ꥯURLServlet̾θ饯ʸˤ
     * ĥѥ֤ޤ.
     *
     * @return    ѥ.
     */
    virtual std::string getPathTranslated()=0;

    /**
     * ꥯȤΥƥȥѥޤ.
     *
     * @return    ƥȥѥ.
     */
    virtual std::string getContextPath()=0;

    /**
     * ꥯȤΥ꡼ޤ.
     *
     * @return    ꡼.
     */
    virtual std::string getQueryString()=0;

    /**
     * ꥯȤΥ桼̾ޤ.
     *
     * @return    桼̾.
     */
    virtual std::string getRemoteUser()=0;

    /**
     * ǧڤƤ桼ꤵ줿˴ޤޤƤ뤫֤ޤ.
     *
     * @return    bool.
     */
    virtual bool isUserInRole()=0;

    /**
     * ߤǧڥ桼̾ޤjava.security.Principal ֥Ȥ
     * ֤ޤ.
     *
     * @return Principal֥.
     */
    virtual sl::java::security::Principal &getUserPrincipal()=0;

    /**
     * 饤Ȥˤäƻꤵ줿åID֤ޤ.
     *
     * @return    åID.
     */
    virtual std::string getRequestedSessionId()=0;

    /**
     * ΥꥯȤ˴Ϣդ줿å󥪥֥Ȥޤ.
     *
     * @return    å󥪥֥.
     */
    virtual HttpSession &getSession(bool flag)=0;

    /**
     * ΥꥯȤ˴Ϣդ줿å󥪥֥Ȥޤ.
     *
     * @return    å󥪥֥.
     */
    virtual HttpSession &getSession()=0;

    /**
     * ꥯȤURIޤ.
     *
     * @return    URI.
     */
    virtual std::string getRequestURI()=0;

    /**
     * ꥯȤURLޤ.
     *
     * @return    URL.
     */
    virtual std::string getRequestURL()=0;

    /**
     * ꥯURL饵֥åȥѥ֤ޤ.
     * ̾盧Υѥ "/" Ϥޤޤ.
     * CGI ǻѤ "SCRIPT_NAME" ƱͤȤʤߤǤ.
     *
     * @return    Servlet Path.
     */
    virtual std::string getServletPath()=0;

    /**
     * ꥯȤ줿åIDͭǤ뤫ɤĴ٤ޤ.
     *
     * @return    bool.
     */
    virtual bool isRequestedSessionIdValid()=0;

    /**
     * ꥯȤ줿åIDCookieȤƤΤĴ٤ޤ.
     *
     * @return    bool.
     */
    virtual bool isRequestedSessionIdFromCookie()=0;

    /**
     * ꥯȤ줿åIDURLȤƤΤɤĴ٤ޤ.
     *
     * @return    bool.
     */
    virtual bool isRequestedSessionIdFromURL()=0;
};

} // namespace http
} // namespace servlet

#endif    // SERVLET_HTTP_HTTP_SERVLET_REQUEST_H
