/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_HTTP_HTTP_SERVLET_H
#define SERVLET_HTTP_HTTP_SERVLET_H

#include <servlet/ServletException.h>
#include <servlet/GenericServlet.h>

namespace servlet {
namespace http {

class HttpServletRequest;
class HttpServletResponse;

/**
 * HTTP ץȥò Servlet ٤˻Ѥ륯饹Ǥ.
 *
 * HTTP γƥꥯȤбдؿƤꡢǥեȤǤ
 * <ol>
 *   <li>GET ᥽å : doGet дؿ</li>
 *   <li>HEAD ᥽å : doHead дؿ</li>
 *   <li>POST ᥽å : doPopst дؿ</li>
 *   <li>PUT ᥽å : doPut дؿ</li>
 *   <li>DELETE ᥽å : doDelete дؿ</li>
 *   <li>TRACE ᥽å : doTrace дؿ</li>
 *   <li>OPTIONS ᥽å : doOptions дؿ</li>
 * </ol>
 * ȤʤäƤޤ. 
 * HttpServlet Ѿ Servlet ϳƥ᥽åɤˤ碌дؿ
 * С饤ɤ뤳Ȥˤƥ᥽åɤòԤʤȤ
 * ǽǤ.
 *
 * С饤ɤʤ嵭Υдؿϥ쥹ݥ󥹤Ȥ
 * @c 415 @c Method @c Not @c Allowed 򥯥饤Ȥ֤ޤ.
 */
class HttpServlet : virtual public GenericServlet {
public :

    /** ⤷ޤ. */
    HttpServlet();

    /** ⤷ޤ. */
    virtual ~HttpServlet();

    virtual void init() throw(ServletException);

    virtual void destroy() throw();

    /**
     * ǥեȤǤ HttpServletRequest ڤ HttpServletResponse 
     * ˤȤ service дؿƤӽФޤ.
     *
     * @param    req        饤Ȥ׵ᥪ֥.
     * @param    res        饤Ȥؤαݻ륪֥.
     * @throw    ServletException    μԻ˥ޤ.
     */
    virtual void service(ServletRequest& req, ServletResponse& res)
        throw(ServletException);

protected :

    /**
     * HttpServletRequest ڤ HttpServletResponse ˼
     * service дؿǤꡢǥեȤǤϥꥯȤб
     * doXXX дؿƤӽФޤ.
     *
     * @param    req        饤Ȥ׵ᥪ֥.
     * @param    res        饤Ȥؤαݻ륪֥.
     * @throw    ServletException    μԻ˥ޤ.
     */
    virtual void service(HttpServletRequest& req, HttpServletResponse& res)
        throw(ServletException);

    /**
     * HTTP ꥯȤ GET ᥽åɤ٤ΥдؿǤ.
     *
     * @param    req        饤Ȥ׵ᥪ֥.
     * @param    res        饤Ȥؤαݻ륪֥.
     * @throw    ServletException    μԻ˥ޤ.
     */
    virtual void doGet   (HttpServletRequest &req, HttpServletResponse &res)
        throw(ServletException);

    /**
     * HTTP ꥯȤ POS ᥽åɤ٤ΥдؿǤ.
     *
     * @param    req        饤Ȥ׵ᥪ֥.
     * @param    res        饤Ȥؤαݻ륪֥.
     * @throw    ServletException    μԻ˥ޤ.
     */
    virtual void doPost  (HttpServletRequest& req, HttpServletResponse& res)
        throw(ServletException);

    /**
     * HTTP ꥯȤ PUT ᥽åɤ٤ΥдؿǤ.
     *
     * @param    req        饤Ȥ׵ᥪ֥.
     * @param    res        饤Ȥؤαݻ륪֥.
     * @throw    ServletException    μԻ˥ޤ.
     */
    virtual void doPut   (HttpServletRequest& req, HttpServletResponse& res)
        throw(ServletException);

    /**
     * HTTP ꥯȤ HEAD ᥽åɤ٤ΥдؿǤ.
     *
     * @param    req        饤Ȥ׵ᥪ֥.
     * @param    res        饤Ȥؤαݻ륪֥.
     * @throw    ServletException    μԻ˥ޤ.
     */
    virtual void doHead  (HttpServletRequest& req, HttpServletResponse& res)
        throw(ServletException);

    /**
     * HTTP ꥯȤ DELETE ᥽åɤ٤ΥдؿǤ.
     *
     * @param    req        饤Ȥ׵ᥪ֥.
     * @param    res        饤Ȥؤαݻ륪֥.
     * @throw    ServletException    μԻ˥ޤ.
     */
    virtual void doDelete(HttpServletRequest& req, HttpServletResponse& res)
        throw(ServletException);

    /**
     * HTTP ꥯȤ TRACE ᥽åɤ٤ΥдؿǤ.
     *
     * @param    req        饤Ȥ׵ᥪ֥.
     * @param    res        饤Ȥؤαݻ륪֥.
     * @throw    ServletException    μԻ˥ޤ.
     */
    virtual void doTrace (HttpServletRequest& req, HttpServletResponse& res)
        throw(ServletException);

    /**
     * HTTP ꥯȤ OPTIONS ᥽åɤ٤ΥдؿǤ.
     *
     * @param    req        饤Ȥ׵ᥪ֥.
     * @param    res        饤Ȥؤαݻ륪֥.
     * @throw    ServletException    μԻ˥ޤ.
     */
    virtual void doOptions(HttpServletRequest& req,HttpServletResponse& res)
        throw(ServletException);
};

} // namespace http
} // namespace servlet

#endif // SERVLET_HTTP_HTTP_SERVLET_H
