/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_HTTP_COOKIE_H
#define SERVLET_HTTP_COOKIE_H

#include <string>

#include <sl/java/lang/IllegalArgumentException.h>
#include <servlet/ServletException.h>

namespace servlet {
namespace http {

/**
 * HTTP ˤ Cookie ɽޤ.
 *
 * Cookie 饹ϥ饤ȤΥꥯȵڤӡ饤Ȥؤ
 * 쥹ݥ󥹤ꤵ졢@c HttpServletReqest::getCookie дؿڤӡ
 * @c HttpServletResponse::addCookie дؿˤäޤ.
 */
class Cookie {
public :
    /**
     * ˻ꤵ줿̾ͤ Cookie 󥹥󥹤ۤޤ.
     *
     * Cookie ˻ǽ̾ RFC 2109 ˽äʸ
     * ʤФʤޤ.
     *
     * @param    n    ꤹ Cookie ̾.
     * @param    n    ꤹ Cookie .
     * @throw    sl::java::lang::IllegalArgumentException
     *            RFC 2109 ˽äƤʤʸꤵ줿˥ޤ.
     *
     */
    Cookie(const std::string& n, const std::string& v)
        throw (sl::java::lang::IllegalArgumentException);

    /**
     * Cookie ФꤵƤ륳Ȥ֤ޤ.
     *
     * @return    ꤵƤ륳Ȥ std::string.
     */
    std::string getComment() const;

    /**
     * Cookie ɤΤ褦ŪäƤΤ򵭽Ҥ륳Ȥ
     * åȤޤ.
     *
     * @param    s    .
     */
    void setComment(const std::string& s);

    /**
     *  Cookie ˥åȤƤɥᥤ֤̾ޤ.
     *
     */
    std::string getDomain() const;

    /**
      *  Cookie ɤ줿ɽɥᥤꤷޤ  
     */
    void setDomain(const std::string& s);

    /**
     * Cookie κĹ¸³֤ͤñ̤ο֤ͤޤ.
     */
    int getMaxAge() const;

    /**
     * Cookie κĹ¸³֤ñ̤ꤷޤ  
     */
    void setMaxAge(int i);

    /**
     * Cookie ֤̾ޤ 
     */
    std::string getName() const;

    /**
     * ֥饦֤Ƥ Cookie ˴ޤޤƤ륵оΥѥ֤ޤ.
     */
    std::string getPath() const;

    /**
     * 饤Ȥ Cookie ֤ʤƤϤʤѥꤷޤ  
     */
    void setPath(const std::string& s);

    /**
     * 奢ʥץȥȤäƤΤߡ ֥饦 Cookie 
     * äƤ褦ˤʤäƤʤ true ֤ޤ  
     */
    bool getSecure() const;

    /**
     * HTTPS  SSL Τ褦ʥ奢ʥץȥȤäƤΤ
     * Cookie ֤褦˥֥饦˻ؼޤ  
     */
    void setSecure(bool flag);

    /**
     * Cookie ֤ͤޤ 
     */
    std::string getValue() const;

    /**
     * Cookie 줿ǡͤꤷޤ  
     */
    void setValue(const std::string& v);

    /**
     * 줾λͤ˼ޤ줿 Cookie ΥץȥΥС֤ޤ.
     */
    int getVersion() const;

    /**
     *   Cookie ѤƤץȥΥСꤷޤ  
     */
    void setVersion(int v);

private :
    std::string _name;
    std::string _value;
    std::string _comment;
    std::string _domain;
    std::string _uri;
    int _age;
    int _version;
    bool _secure;
};

} // namespace http
} // namespace servlet

#endif // SERVLET_HTTP_COOKIE_H
