/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_SERVLET_RESPONSE_WRAPPER_H
#define SERVLET_SERVLET_RESPONSE_WRAPPER_H

#include <sl/java/util/Locale.h>
#include <sl/java/io/PrintWriter.h>
#include <servlet/ServletException.h>
#include <servlet/ServletResponse.h>

namespace servlet {

/**
 * ServletResponse 饹ñ˷ѾĥԤʤ٤Υ饹Ǥ.
 *
 * ServletResponseWrapper γƥдؿϥǥեȤǤ
 * 󥹥ȥ饯Ϥ줿 ServletResponse γƥдؿƤӽФޤ.
 */
class ServletResponseWrapper : public ServletResponse {
public :
    /**
     *  response åפ ServletResponseWrapper ۤޤ.
     */
    ServletResponseWrapper(ServletResponse& response);

    /** ⤷ʤ. */
    virtual ~ServletResponseWrapper();

    /**
     * åפƤ ServletResponse Υдؿ
     * ServletResponse::getWriter ƤӽФޤ.
     */
    virtual sl::java::io::PrintWriter& getWriter() throw(ServletException);

    /**
     * åפƤ ServletResponse Υдؿ 
     * ServletResponse::getOutputStream ƤӽФޤ.
     *
     * @return    Instance of std::ostream class.
     */
    virtual ServletOutputStream& getOutputStream();

    /**
     * åפƤ ServletResponse Υдؿ 
     * ServletResponse::setContentType ƤӽФޤ.
     *
     * @param    s    ContentType.
     */
    virtual void setContentType(const std::string& s);

    /**
     * åפƤ ServletResponse Υдؿ 
     * ServletResponse::getContentType ƤӽФޤ.
     *
     * @return    `ContentType`
     */
    virtual std::string getContentType();

    /**
     * åפƤ ServletResponse Υдؿ 
     * ServletResponse::setContentLength ƤӽФޤ.
     *
     * @param    i    value of `Content-Length`.
     */
    virtual void setContentLength(int i);

    /**
     * åפƤ ServletResponse Υдؿ 
     * ServletResponse::getCharacterEncoding ƤӽФޤ.
     *
     * @return    `CharacterEncoding`
     */
    virtual std::string getCharacterEncoding();

    /**
     * åפƤ ServletResponse Υдؿ 
     * ServletResponse::getLocale ƤӽФޤ.
     *
     * @return    Locale 󥹥.
     */
    virtual sl::java::util::Locale getLocale();

    /**
     * åפƤ ServletResponse Υдؿ 
     * ServletResponse::setLocale ƤӽФޤ.
     *
     * @param    l    Locale 󥹥.
     */
    virtual void setLocale(const sl::java::util::Locale& l);

    /**
     * åפƤ ServletResponse Υдؿ 
     * ServletResponse::setBufferSize ƤӽФޤ.
     *
     * @param    size    size of buffer.
     */
    virtual void setBufferSize(size_t size);

    /**
     * åפƤ ServletResponse Υдؿ 
     * ServletResponse::getBufferSize ƤӽФޤ.
     *
     * @return    size of the buffer.
     */
    virtual size_t getBufferSize();

    /**
     * åפƤ ServletResponse Υдؿ 
     * ServletResponse::isCommitted ƤӽФޤ.
     *
     * @return    bool.
     */
    virtual bool isCommitted();

    /**
     * åפƤ ServletResponse Υдؿ 
     * ServletResponse::flushBuffer ƤӽФޤ.
     *
     */
    virtual void flushBuffer();

    /**
     * åפƤ ServletResponse Υдؿ 
     * ServletResponse::reset ƤӽФޤ.
     *
     */
    virtual void reset();

    /**
     * åפƤ ServletResponse Υдؿ 
     * ServletResponse::resetBuffer ƤӽФޤ.
     *
     */
    virtual void resetBuffer();

protected :
    servlet::ServletResponse& _instance;
};

} // namespace servlet

#endif    // SERVLET_SERVLET_RESPONSE_WRAPPER_H
