/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_SERVLET_RESPONSE_H
#define SERVLET_SERVLET_RESPONSE_H

#include <sl/java/io/PrintWriter.h>
#include <sl/java/util/Locale.h>
#include <servlet/ServletException.h>

namespace servlet {

class ServletOutputStream;

/**
 * @interface ServletResponse.
 * Servlet 饤Ȥ׵Ф Servlet ꤹ٤
 * 󥿡եޤ.
 *
 * ServletReponse 饹μ Servlet ƥʤˤäƺ졢
 * Servlet::service дؿΰˤä Servlet ˰Ϥޤ.
 * 
 * @warning        serLocale дؿϼƤޤ.
 */
class ServletResponse {
public :
    /** Destructor. */
    virtual ~ServletResponse()=0;

    /**
     * 饤Ȥ˱֤٤ @c sl::java::io::PrintWriter
     * 󥹥󥹤֤ޤ.
     *
     * @c getOutputStream дؿƤӽФ
     * @c getWriter дؿƤӽФԤʤ㳰ȯޤ.
     *
     * @return    饤Ȥ˱֤٤
     *            @c sl::java::io::PrintWriter 󥹥.
     */
    virtual sl::java::io::PrintWriter& getWriter()=0;

    /**
     * 饤Ȥ˱֤٤ @c ServletOutputStream 󥹥󥹤
     * ֤ޤ.
     *
     * @c getOutputStream дؿƤӽФ
     * @c getWriter дؿƤӽФԤʤ㳰ȯޤ.
     *
     * @return    饤Ȥ˱֤٤
     *            @c ServletOutputStream 󥹥.
     */
    virtual ServletOutputStream& getOutputStream()=0;

    /**
     * 饤ȤФ쥹ݥ󥹤Υƥȥפ򥻥åȤޤ.
     *
     * @param    s    ꤹ륳ƥȥפ򼨤 std::string.
     */
    virtual void setContentType(const std::string &s)=0;

    /**
     * 쥹ݥ󥹤ΥåܥǥĹꤷޤ.
     *
     * @param    i    åܥǥĹ.
     */
    virtual void setContentLength(int i)=0;

    /**
     * Υ쥹ݥ󥹤֤ MIME ܥǥŬѤƤ
     * 󥳡ǥ֤̾ޤ.
     *
     * @return    󥳡ǥ̾򼨤 std::string.
     */
    virtual std::string getCharacterEncoding()=0;

    /**
     * Υ쥹ݥ󥹤˴ꤵƤ ƥȥפ֤ޤ.
     *
     * @return    ƥȥפ򼨤 std::string.
     */
    virtual std::string getContentType()=0;

    /**
     * Υ쥹ݥ󥹤˴ꤵƤ Locale 󥹥󥹤֤ޤ.
     *
     * @return    Locale 󥹥.
     */
    virtual sl::java::util::Locale getLocale()=0;

    /**
     * Υ쥹ݥ󥹤Ф Locale ꤷޤ.
     *
     * @param    l    Locale 󥹥.
     */
    virtual void setLocale(const sl::java::util::Locale& l)=0;

    /**
     * The size of the buffer used to make a response is set.
     * @param    size    size of buffer.
     */
    virtual void setBufferSize(size_t size)=0;

    /**
     * The size of the buffer used to make a response is returned.
     * @return    size of the buffer.
     */
    virtual size_t getBufferSize()=0;

    /**
     * It is returned whether the response has already been committed.
     * @return    bool.
     */
    virtual bool isCommitted()=0;

    /**
     * The buffer for the response is output to the client.
     */
    virtual void flushBuffer()=0;

    /**
     * The buffer and the header for the response are cleared.
     */
    virtual void reset()=0;

    /**
     * Only the buffer for the response is cleared.
     */
    virtual void resetBuffer()=0;
};

} // namespace servlet

#endif    // SERVLET_SERVLET_RESPONSE_H
