/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_SERVLET_REQUEST_WRAPPER_H
#define SERVLET_SERVLET_REQUEST_WRAPPER_H

#include <string>
#include <vector>
#include <map>

#include <sl/java/io/BufferedReader.h>
#include <sl/java/lang/Object.h>
#include <sl/java/util/Enumeration.h>
#include <sl/java/util/Locale.h>
#include <servlet/ServletException.h>
#include <servlet/ServletRequest.h>
#include <servlet/RequestDispatcher.h>

namespace servlet {

class ServletInputStream;

/**
 * ServletRequest 饹ñ˷ѾĥԤʤ٤Υ饹Ǥ.
 *
 * ServletRequestWrapper γƥдؿϥǥեȤǤ
 * 󥹥ȥ饯Ϥ줿 ServletRequest γƥдؿƤӽФޤ.
 */
class ServletRequestWrapper : public ServletRequest {
public :
    /**
     *  request åפ ServletRequestWrapper ۤޤ.
     *
     * @param    request        åоݤ ServletRequest 󥹥.
     */
    ServletRequestWrapper(ServletRequest& request);

    /** ⤷ޤ.  */
    virtual ~ServletRequestWrapper();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getAttribute ƤӽФޤ.
     *
     * @param   name    °̾.
     * @return  sl::java::lang::Object ̾ȥڥȤʤ°.
     */
    virtual sl::java::lang::Object getAttribute(const std::string& name);

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::setAttribute ƤӽФޤ.
     *
     * @param   name    ꤹ°̾.
     * @param   obj        ꤹ sl::java::lang::Object °.
     */
    virtual void
    setAttribute(const std::string& name, sl::java::lang::Object obj);

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::removeAttribute ƤӽФޤ.
     *
     * @param   name    ꤹ°̾.
     */
    virtual void removeAttribute(const std::string &s);

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getAttributeNames ƤӽФޤ.
     *
     * @return      °̾ΥꥹȤݻ sl::java::util::Enumeration 
     *              󥹥.
     */
    virtual sl::java::util::Enumeration getAttributeNames();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getParameter ƤӽФޤ.
     *
     * @param   name    ׵ѥ᡼̾.
     * @return   name б׵ѥ᡼.
     */
    virtual std::string getParameter(const std::string &name);

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getParameterNames ƤӽФޤ.
     *
     * @return  ׵ѥ᡼̾Υꥹ.
     */
    virtual sl::java::util::Enumeration getParameterNames();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getParameterValues ƤӽФޤ.
     *
     * @param   name    ׵ѥ᡼̾.
     * @return   name б׵ѥ᡼ͤݻ
     *            @c std::vector<@c std::string> 󥹥.
     */
    virtual std::vector<std::string>
    getParameterValues(const std::string& name);

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getParameterMap ƤӽФޤ.
     *
     * @return  @c std::multimap<@c std::string, @c std::string>
     *            󥹥.
     */
    virtual std::multimap<std::string, std::string> getParameterMap();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getCharacterEncoding ƤӽФޤ.
     *
     * @return  ʸ󥳡ǥ󥰤򼨤 std::string 󥹥.
     */
    virtual std::string getCharacterEncoding();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::setCharacterEncoding ƤӽФޤ.
     *
     * @param    s    ʸ󥳡ǥ󥰤򼨤 std::string 󥹥.
     */
    virtual void setCharacterEncoding(const std::string& s);

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getContentLength ƤӽФޤ.
     *
     * @return  ɤ߽ФǽʥХĹ.
     */
    virtual int getContentLength();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getContentType ƤӽФޤ.
     *
     * @return    MIME .
     */
    virtual std::string getContentType();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getInputStream ƤӽФޤ.
     *
     * @return  åܥǥɤ߹٤
     *            @c ServletInputStream 󥹥.
     * @throw   sl::java::lang::IllegalStateException.
     */
    virtual ServletInputStream &getInputStream();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getReader ƤӽФޤ.
     *
     * @return  åܥǥɤ߹٤
     *            @c BufferedReader 󥹥.
     * @throw   sl::java::lang::IllegalStateException.
     */
    virtual sl::java::io::BufferedReader getReader();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getLocale ƤӽФޤ.
     *
     * @return    sl::java::util::Locale 󥹥.
     */
    virtual sl::java::util::Locale getLocale();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getLocales ƤӽФޤ.
     *
     * @return    륤󥹥󥹤Υꥹ.
     */
    virtual sl::java::util::Enumeration getLocales();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getProtocol ƤӽФޤ.
     *
     * @return    ץȥ̾ȥСޤ std::string.
     */
    virtual std::string getProtocol();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getScheme ƤӽФޤ.
     *
     * @return    ޤ std::string.
     */
    virtual std::string getScheme();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::isSecure ƤӽФޤ.
     *
     * @return    奢̿ɤ򼨤 bool .
     */
    virtual bool isSecure();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getServerName ƤӽФޤ.
     *
     * @return    ꥯȤ̾ޤ std::string.
     */
    virtual std::string getServerName();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getServerPort ƤӽФޤ.
     *
     * @return    ꥯȤݡֹ.
     */
    virtual int getServerPort();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getLocalAddr ƤӽФޤ.
     *
     * @return    Servlet ƥʤưƤۥȤIPɥ쥹.
     */
    virtual std::string getLocalAddr();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getLocalName ƤӽФޤ.
     *
     * @return    Servlet ƥʤưƤۥȤ̾.
     */
    virtual std::string getLocalName();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getLocalPort ƤӽФޤ.
     *
     * @return    Servlet ƥʤưƤۥȤΥݡֹ.
     */
    virtual int getLocalPort();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getRemoteAddr ƤӽФޤ.
     *
     * @return    饤ȤIPɥ쥹.
     */
    virtual std::string getRemoteAddr();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getRemoteHost ƤӽФޤ.
     *
     * @return    饤ȤΥۥ̾.
     */
    virtual std::string getRemoteHost();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getRemotePort ƤӽФޤ.
     *
     * @return    饤ȤΥݡֹ.
     */
    virtual int getRemotePort();

    /**
     * åפƤ ServletRequest Υдؿ 
     * ServletRequest::getRequestDispatcher ƤӽФޤ.
     *
     * @param   path   ꥽ؤΥѥ.
     * @return  б RequestDispatcher 󥹥.
     */
    virtual std::auto_ptr<RequestDispatcher>
    getRequestDispatcher(const std::string& path);

private :
    ServletRequest& _instance;
};

} // namespace servlet

#endif    // SERVLET_SERVLET_REQUEST_WRAPPER_H
