/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_SERVLET_REQUEST_EVENT_H
#define SERVLET_SERVLET_REQUEST_EVENT_H

#include <sl/java/util/EventObject.h>
#include <servlet/ServletContext.h>
#include <servlet/ServletRequest.h>

namespace servlet {

/**
 * @c ServletRequest Ѳ @c ServletRequestListener ٤
 * Ѥ륤٥Ȥɽ륯饹Ǥ.
 *
 * @warning        Ѿ sl::java::util::EventObject ݻ source
 *                ѿϰڻѤƤޤ.
 */
class ServletRequestEvent : public sl::java::util::EventObject {
public :
    /**
     * ٥ȤȯǤϤ @ ServletRequest 󥹥󥹤
     *  @c ServletRequest ݻ @c ServletContext ˤä
     * @c ServletRequestEvent 󥹥󥹤ۤޤ.
     *
     * @param    sc        ٥ȯ @c ServletContext 󥹥
     *                    ؤλ.
     * @param    req        ٥ȯ @c ServletRequest 󥹥
     *                    ؤλ.
     */
    ServletRequestEvent(ServletContext& sc, ServletRequest& req)
        : sl::java::util::EventObject(sl::java::lang::Object()),
          _context(sc), _request(req)
    { }

    /**
     * ٥ȤȯȤʤä @c ServletRequest Ǥ
     * @c ServletContext Υ󥹥󥹤֤ޤ.
     *
     * @param    ٥Ȥȯ @c ServletContext 󥹥󥹤ؤλ.
     */
    virtual ServletContext& getServletContext()
    {
        return _context;
    }

    /**
     * ٥ȤȯȤʤä @c ServletRequest 󥹥󥹤֤ޤ.
     *
     * @param    ٥Ȥȯ @c ServletRequest 󥹥󥹤ؤλ.
     */
    virtual ServletRequest& getServletRequest()
    {
        return _request;
    }

private :
    ServletContext& _context;
    ServletRequest& _request;
};

} // namespace servlet

#endif // SERVLET_SERVLET_REQUEST_EVENT_H
