/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_OUTPUT_STREAM_H
#define SERVLET_OUTPUT_STREAM_H

#include <sstream>

#include <sl/java/io/OutputStream.h>
#include <servlet/ServletException.h>

namespace servlet {

/**
 * @interface ServletOutputStream.
 * 饤Ȥ˥ХʥǡϤ٤˻Ѥޤ.
 *
 * @c ServletOutputStream 󥹥󥹤̾
 * @c ServletResponse::getOutputStream дؿѤƼޤ.
 *
 */
class ServletOutputStream : virtual public sl::java::io::OutputStream {
public :

    /** Destructor. */
    virtual ~ServletOutputStream();

    /**
     * @c ValueType 򥯥饤Ȥ˽Ϥޤ.
     *
     * @c print ƥץ졼ȥдؿ @c operator<< Ѥˤä
     *  x ϲǽʸؤѴޤΤǡ桼
     * @c print дؿ˻Ѥ
     * @c operator<<(@c std::ostream&, @c ValueType& @c x) μɬפǤ.
     *
     * @param    x    ϤԤʤ饹󥹥󥹤ޤ
     *                ץߥƥ֤ʷѿ.
     */
    template <typename ValueType>
    void print(ValueType x)
    {
        std::ostringstream s;
        s << x;
        write(s.str(), 0, s.str().length());
    }

    /**
     * @c bool ĥǡ򥯥饤Ȥ˽Ϥޤ.
     * Ϥǡʸ "true" ޤ "false" Ȥʤޤ.
     *
     * @param    x    bool ѿ.
     */
    void print(bool x)
    {
        std::string s = x ? "true" : "false";
        write(s, 0, s.length());
    }

    /**
     * @c ValueType 򥯥饤Ȥ˽Ϥޤ.
     *
     * @c println дؿ @c print дؿ¹Ԥ
     * θ CRLF ϤǤ.
     *
     * @param    x    ϤԤʤ饹󥹥󥹤ޤ
     *                ץߥƥ֤ʷѿ.
     * @see        @c ServletOutputStream::print дؿ.
     */
    template <typename ValueType>
    void println(ValueType x)
    {
        print(x);
        print("\r\n");
    }

    /**
     * @c CRLF 򥯥饤Ȥ˽Ϥޤ.
     *
     * ֤ @c print("\r\n\r\n"); Ǥ.
     *
     * @see        @c ServletOutputStream::print дؿ.
     */
    void println()
    {
        print("\r\n");
    }
};

} // namespace servlet

#endif // SERVLET_OUTPUT_STREAM_H
