/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_SERVLET_CONTEXT_LISTENER_H
#define SERVLET_SERVLET_CONTEXT_LISTENER_H

#include <sl/java/util/EventListener.h>
#include <servlet/ServletContextEvent.h>


namespace servlet {

/**
 * @interface.
 *
 * Web ץꥱѹȼ @c ServletContext 
 * ٥ȤˤΤȤƼդ٤Υ󥿡եޤ.
 *
 * ꥹʡΥɤ Servlet ƥʤεưˤΤ߹Ԥʤ졢
 * Web ץꥱһҤξ˽äƹԤʤޤ.
 */
class ServletContextListener : public sl::java::util::EventListener {
public :
    /** Destructor. */
    virtual ~ServletContextListener() { }

    /**
     * Web ץꥱνϤǸƤӽФؿǤ.
     *
     * Ʊ Web ץꥱ @c Filter  @c Servlet ν
     * ¹Ԥޤ.
     *
     * @param    e    @c ServletContext ݻ @c ServletContextEvent
     *                󥹥󥹤ؤλ.
     */
    virtual void contextInitialized(ServletContextEvent& e)=0;

    /**
     * Web ץꥱνλλǸƤӽФؿǤ.
     *
     * Ʊ Web ץꥱ @c Filter  @c Servlet νλ
     * ¹Ԥޤ.
     *
     * @param    e    @c ServletContext ݻ @c ServletContextEvent
     *                󥹥󥹤ؤλ.
     */
    virtual void contextDestroyed(ServletContextEvent& e)=0;
};

} // namespace servlet

#endif // SERVLET_SERVLET_CONTEXT_LISTENER_H
