/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_SERVLET_CONTEXT_ATTRIBUTE_LISTENER_H
#define SERVLET_SERVLET_CONTEXT_ATTRIBUTE_LISTENER_H

#include <sl/java/util/EventListener.h>
#include <servlet/ServletContextAttributeEvent.h>

namespace servlet {

/**
 * @interface.
 *
 * Web ץꥱɽ ServletContext °Ф
 * ͤɲáѹˤ륤٥Τդ٤Υ󥿡ե
 * ޤ.
 *
 * ꥹʡΥɤ Servlet ƥʤεưˤΤ߹Ԥʤ졢
 * Web ץꥱһҤξ˽äƹԤʤޤ.
 */
class ServletContextAttributeListener
    : public sl::java::util::EventListener {
public :
    /** Destructor. */
    virtual ~ServletContextAttributeListener() { }

    /**
     * @c ServletContext Ф°ɲä줿ǸƤӽФؿǤ.
     * °ɲä줿ľ˸ƤӽФ졢 e ˤäɲä줿
     * °Ƥ򻲾Ȥޤ.
     *
     * @param    e    °ɲä줿 @c ServletContext ڤӡɲä줿
     *                °Ƥݻ @c ServletContextAttributeEvent
     *                󥹥󥹤ؤλ.
     */
    virtual void attributeAdded(ServletContextAttributeEvent& e)=0;

    /**
     * @c ServletContext Ф°줿ǸƤӽФؿǤ.
     * °줿ľ˸ƤӽФ졢 e ˤäƺ줿
     * °Ƥ򻲾Ȥޤ.
     *
     * @param    e    °줿 @c ServletContext ڤӡ줿
     *                °Ƥݻ @c ServletContextAttributeEvent
     *                󥹥󥹤ؤλ.
     */
    virtual void attributeRemoved(ServletContextAttributeEvent& e)=0;

    /**
     * @c ServletContext Ф°ѹ줿ǸƤӽФؿǤ.
     * °ѹ줿ľ˸ƤӽФ졢 e ˤäѹ줿
     * °Ƥ򻲾Ȥޤ.
     *
     * @param    e    °ѹ줿 @c ServletContext ڤӡѹ줿
     *                °Ƥݻ @c ServletContextAttributeEvent
     *                󥹥󥹤ؤλ.
     */
    virtual void attributeReplaced(ServletContextAttributeEvent& e)=0;
};

} // namespace servlet

#endif // SERVLET_SERVLET_CONTEXT_ATTRIBUTE_LISTENER_H
