/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_SERVLET_CONTEXT_ATTRIBUTE_EVENT_H
#define SERVLET_SERVLET_CONTEXT_ATTRIBUTE_EVENT_H

#include <string>
#include <servlet/ServletContextEvent.h>

namespace servlet {

/**
 * @c ServletContext °ФѲ @c ServletContextAttributeListener
 * ٤˻Ѥ륤٥Ȥɽ륯饹Ǥ.
 *
 * @warning        Ѿ sj::java::util::EventObject ݻ source
 *                ѿϰڻѤƤޤ.
 */
class ServletContextAttributeEvent : public ServletContextEvent {
public :
    /**
     * °ѹ줿 @ ServletContext 󥹥󥹤ݻ
     * @c ServletContextAttributeEvent 󥹥󥹤ۤޤ.
     *
     * @param    source    ٥ȯ @c ServletContext 󥹥󥹤ؤ
     *                    .
     * @param    name    ѹ줿°̾.
     * @param    value    ѹ줿°.
     */
    ServletContextAttributeEvent(ServletContext& source,
        const std::string& name, const sl::java::lang::Object& value)
        : ServletContextEvent(source), _name(name), _value(value)
    { }

    /**
     * ѹ줿°֤̾ޤ.
     *
     * @return    ѹ줿°̾򼨤 std::string.
     */
    virtual std::string getName()
    {
        return _name;
    }

    /**
     * ѹ줿°֤ͤޤ.
     *
     * @return    ѹ줿°ͤݻ sj::java::lang::Object.
     */
    virtual sl::java::lang::Object getValue()
    {
        return _value;
    }

private :
    std::string _name;
    sl::java::lang::Object _value;
};

} // namespace servlet

#endif // SERVLET_SERVLET_CONTEXT_ATTRIBUTE_EVENT_H
