/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_SERVLET_CONTEXT_H
#define SERVLET_SERVLET_CONTEXT_H

#include <fstream>
#include <string>
#include <set>

#include <sl/java/lang/Object.h>
#include <sl/java/util/Enumeration.h>
#include <servlet/ServletException.h>
#include <servlet/RequestDispatcher.h>

namespace servlet {

/**
 * @interface ServletContext.
 * Servlet Ф Web ץꥱɽServlet 
 * Servlet ƥʤ˥٤νޤ.
 *
 * servlet::ServletConfig::getServletContext дؿǼǽǤ.
 */
class ServletContext {
public :
    /** Destructor. */
    virtual ~ServletContext()=0;

    /**
     * ServletContext μԤʤʤ
     *  null 󥹥󥹤Ȥʤ뤿ᡢؽȤƻѤޤ.
     *
     * Ǥ Web ץꥱۤ ServletContext μ
     * Ԥʤʤᡢnull 󥹥󥹤֤ޤ.
     *
     * <pre>
     *   ServletContext& c = getServletContext();
     *   if (!c) { 
     *       //  餫Υ顼
     *       :
     *       return;
     *   }
     *   c.getAttribute(s);   //  ɬפʽԤʤ.
     * </pre>
     *
     * @return    ServletContext ѲǽǤ뤫Ƚ.
     */
    virtual bool operator!()=0;

    /**
     *  name ˤäƻꤵ줿̾°֤ޤ.
     *
     * °̾ͤΥڥ ServletContext ڤ Servlet 
     *  Servlet ƥʡ⤷ Servlet Ȥˤäꡢ
     * Ԥʤޤ.
     * ޤб°¸ߤʤ null 󥹥󥹤֤ޤ.
     *
     * @param    name    °̾.
     * @return    sl::java::lang::Object ̾ȥڥȤʤ°.
     * @note    java.*, javax.*, sun.* ˳̾ Servlet API    ͤ
     *            ͽ󤵤Ƥ뤽ʤΤǡǤϻѤƤޤ.
     */
    virtual sl::java::lang::Object getAttribute(const std::string& name)=0;

    /**
     *  obj   name ˤäƻꤵ줿̾°Ȥ
     * ꤷޤ.
     *
     * ˻ꤵ줿̾°ꤷ֤ޤ.
     *
     * ͤȤ null ݻ obj Ϥ줿ϡremoveAttribute 
     * дؿθƤӽФˤʤޤ.
     *
     * ǤдϢꥹʡ֥Ȥ¸ߤŬڤ
     * Τ٤ǤǤϥꥹʡϢνϼƤޤ.
     *
     * @param    name    ꤹ°̾.
     * @param    obj        ꤹ sl::java::lang::Object °.
     * @note    java.*, javax.*, sun.* ˳̾ Servlet API    ͤ
     *            ͽ󤵤Ƥ뤽ʤΤǡǤϻѤƤޤ.
     */
    virtual void
    setAttribute(const std::string& name, sl::java::lang::Object obj)=0;

    /**
     *  name ˤäƻꤵ줿̾°ޤ.
     *
     * @c removeAttribute дؿˤäƺ줿°Ф
     * Ԥʤä null 󥹥󥹤֤ޤ.
     * 
     * @param    name    ꤹ°̾.
     */
    virtual void removeAttribute(const std::string& name)=0;

    /**
     * ServletContext ݻ°̾ΥꥹȤ֤ޤ.
     *
     * @return        °̾ΥꥹȤݻ sl::java::util::Enumeration 
     *                󥹥.
     */
    virtual sl::java::util::Enumeration getAttributeNames()=0;

    /**
     * Web ץꥱһҤǻꤵ줿ѥ᡼
     * ꥹȤ顢 name ̾Ȥƻĥѥ᡼֤ͤޤ.
     *
     * ѥ᡼¸ߤʤ϶ @c std::string ֤ޤ.
     *
     * @param    name    ѥ᡼̾.
     * @return     name бѥ᡼.
     * @note    @c ServletConfig::getInitParameter(name) ֤ͤǤ.
     */
    virtual std::string getInitParameter(const std::string& name)=0;

    /**
     * Web ץꥱһҤǻꤵ줿ѥ᡼
     * ̾ΥꥹȤ֤ޤ.
     *
     * @return    ѥ᡼̾Υꥹ.
     * @note    @c ServletConfig::getInitParameterNames ֤ͤǤ.
     */
    virtual sl::java::util::Enumeration getInitParameterNames()=0;

    /**
     *  uri б ServletContext 󥹥󥹤֤ޤ.
     *
     * Ǥ ¾ Web ץꥱФƥԲǽǤ뤿ᡢ
     *  null 󥹥󥹤֤ޤ.
     *
     * @param    uri         ServletContext ̾.
     * @return    ServletContext Υ󥹥.
     */
    virtual ServletContext& getContext(const std::string& uri)=0;

    /**
     * 򤷤Ƥ Servlet API Υ᥸㡼Сֹ֤ޤ.
     *  `2' Ǥ.
     *
     * @return    ᥸㡼Сֹ.
     */
    virtual int    getMajorVersion()=0;

    /**
     * 򤷤Ƥ Servlet API ΥޥʡСֹ֤ޤ.
     *  `4' Ǥ.
     *
     * @return    ޥʡСֹ.
     */
    virtual int getMinorVersion()=0;

    /**
     *  file  MIME ֤̾ޤ.
     * file Ф MIME ̾Ǥ϶ std::string ֤ޤ.
     *
     * @param    file    ѥޤե̾.
     * @return     MIME ̾.
     */
    virtual std::string getMimeType(const std::string& file)=0;

    /**
     * ꤵ줿ѥΥ꥽Ф RequestDispatcher  󥹥󥹤
     * ֤ޤ.
     *
     * ꤹѥ "/" ǻϤޤäƤʤФʤޤ.
     * ޤб Servlet ʤ null 󥹥
     * ֤ޤ.
     *
     * @param    s    Ԥʤ꥽ؤΥѥ.
     * @return    ѥб RequestDispatcher 󥹥.
     */
    virtual std::auto_ptr<RequestDispatcher>
    getNamedDispatcher(const std::string& s)=0;

    /**
     * Ϳ줿ۥѥбºݤΥѥ
     * string ֥Ȥ֤ޤ
     * @param    s    ۥѥ.
     * @return    ºݤΥѥ.
     *
     * åȤȤʤ s ƥȥեʳΥǥ쥯ȥ
     * ǤäƤ⳺ѥ֤ޤ
     */
    virtual std::string getRealPath(const std::string& s)=0;

    /**
     * ꤵ줿ѥΥ꥽Ф URL ֤ޤ.
     *
     * ꤹѥ "/" ǻϤޤäƤʤФʤޤ.
     * @param    s     s Ф std::string  URL.
     */
    virtual std::string getResource(const std::string& s)=0;

    /**
     * ꤵ줿ѥΥ꥽б std::ifstream 󥹥󥹤
     * ֤ޤ.
     *
     * @param    s    ̾ޤեؤΥѥ.
     */
    virtual std::ifstream& getResourceAsStream(const std::string& s)=0;

    /**
     *  s ǻꤵ줿ѥ˰פǥ쥯ȥꡢե
     * ꥹȤ֤ޤ.
     *
     * @param    s    ˾Υѥ.
     */
    virtual std::set<std::string> getResourcePaths(const std::string& s)=0;

    /**
     * ԡСȤäServlet˴ؤ֤ޤ.
     * 
     * ǥեȤǤ϶ʸ֤ޤ. 
     *
     * @return    Сݻʸ.
     */
    virtual std::string getServerInfo()=0;

    /**
     * Web ץꥱ֤̾ޤ.
     * 
     * @return    Web ץꥱ̾.
     */
    virtual std::string getServletContextName()=0;

    /**
     * ꤵ줿ѥΥ꥽Ф RequestDispatcher  󥹥󥹤
     * ֤ޤ.
     *
     * ꤹѥ "/" ǻϤޤäƤʤФʤޤ.
     * ޤб Servlet ʤ null 󥹥
     * ֤ޤ.
     *
     * @param    s    Ԥʤ꥽ؤΥѥ.
     * @return    ѥб RequestDispatcher 󥹥.
     */
    virtual std::auto_ptr<RequestDispatcher>
    getRequestDispatcher(const std::string& s)=0;

    /**
     *  msg ˽Ϥޤ.
     *
     * Υдؿθ󶡤줿ΤǤꡢ
     * ºݤˤϡ@c init дؿݻ
     * servlet::ServletConfig  servlet::ServletContext 
     * @c ServletContext::log() дؿ¹Ԥޤ.
     *
     * @param    msg        å.
     */
    virtual void log(const std::string& msg)=0;

    /**
     *  e 㳰ޤ᤿Ϥޤ.
     *
     * Υдؿθ󶡤줿ΤǤꡢ
     * ºݤˤϡ@c init дؿݻ
     * servlet::ServletConfig  servlet::ServletContext 
     * @c ServletContext::log() дؿ¹Ԥޤ.
     *
     * @param    msg        å.
     * @param    e        㳰.
     */
    virtual
    void log(const std::string& msg, const sl::java::lang::Exception& e)=0;
};

} // namespace servlet

#endif // SERVLET_SERVLET_CONTEXT_H
