/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_SERVLET_CONFIG_H
#define SERVLET_SERVLET_CONFIG_H

#include <string>
#include <sl/java/util/Enumeration.h>

namespace servlet {

class ServletContext;

/**
 * @interface ServletConfig.
 * Servlet νWeb ץꥱһҤǵҤƤ
 * Ƽѥ᡼ Servlet ٤˻Ѥޤ.
 */
class ServletConfig {
public :
    /** Destructor. */
    virtual ~ServletConfig()=0;

    /**
     * Web ץꥱһҤǻꤵ줿ѥ᡼
     * ̾ΥꥹȤ֤ޤ.
     *
     * @return    ѥ᡼̾Υꥹ.
     */
    virtual sl::java::util::Enumeration getInitParameterNames()=0;

    /**
     * Web ץꥱһҤǻꤵ줿ѥ᡼
     * ꥹȤ顢 name ̾Ȥƻĥѥ᡼֤ͤޤ.
     *
     * ѥ᡼¸ߤʤ϶ std::string ֤ޤ.
     *
     * @param    name    ѥ᡼̾.
     * @return     name бѥ᡼.
     */
    virtual std::string getInitParameter(const std::string& name)=0;

    /**
     * servlet::ServletContext 󥹥󥹤֤ޤ. 
     *
     * @return    servlet::ServletContext 󥹥.
     */
    virtual ServletContext& getServletContext()=0;

    /**
     *  Servlet Υ󥹥󥹤֤̾ޤ.
     *
     * @return     Servlet Υ󥹥󥹤̾.
     */
    virtual std::string getServletName()=0;
};

} // namespace servlet

#endif // SERVLET_SERVLET_CONFIG_H
