/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_SERVLET_H
#define SERVLET_SERVLET_H

#include <servlet/ServletException.h>

namespace servlet {

class ServletConfig;
class ServletRequest;
class ServletResponse;

/**
 * @interface Servlet.
 * Ƥ Servlet ʤФʤʤؿƤޤ.
 *
 * Υ󥿥եˤ servlet::GenericServlet Ѿ
 * Ū̿Ԥ Servlet 򵭽Ҥ뤫 servlet::http::HttpServlet 
 * Ѿ HTTP ˤ̿Ԥ Servlet 򵭽ҤǤ褦ˤʤäƤޤ.
 *
 */
class Servlet {
public :
    /** Constructor */
    Servlet();

    /** Destructor */
    virtual ~Servlet();

    /**
     * Servlet ؤνԤʤΥдؿǤ.
     *
     * @c init дؿ Servlet Υɸ Servlet ƥʤˤä
     * ٤ƤӽФޤ. Servlet Ϥδؿ򥪡С饤ɤ
     * Servlet ͭνԤʤǽǤ.
     *
     * ޤ@c init дؿ ServletException 򥹥
     * Ԥ Servlet ƥʤǧʹߡ
     * @c service дؿ @c destroy дؿ¹Ԥʤ
     * ¨¤˥夫ޤ.
     *
     * @c init дؿϽ貾۴ؿǤ뤿ᡢServlet Ѿ
     * ƤΥ饹ϤΥдؿ򥪡С饤ɤɬפޤ.
     *
     * @param    config        servlet::ServletConfig 󥹥.
     * @throw    ServletException    μԻ˥ޤ.
     */
    virtual void init(ServletConfig& config) throw(ServletException)=0;

    /**
     * Servlet ؤνλԤʤΥдؿǤ.
     *
     * @c destroy дؿ ɤ Servlet ƥʤˤä
     * ٤ƤӽФޤ. Servlet Ϥδؿ򥪡С饤ɤ
     * Servlet ͭνλԤʤǽǤ.
     *
     */
    virtual void destroy() throw()=0;

    /**
     * Servlet ؤ׵٤ΥдؿǤ.
     *
     * Servlet Ϥδؿ򥪡С饤ɤ Servlet ͭΥӥ
     * 󶡤ɬפޤ.
     * service дؿ init дؿ˽λˤ
     * ¹Ԥޤ.
     *
     * @param    req        饤Ȥ׵ɽ륯饹 ServletRequest.
     * @param    res        饤Ȥؤαɽ륯饹 ServletRequest.
     * @throw    ServletException    ʽμԻ˥ޤ.
     */
    virtual void service(ServletRequest& req, ServletResponse& res)
        throw(ServletException)=0;

    /**
     * Servlet 󥹥󥹤°Web ץꥱɽ
     * servlet::ServletContext ؤλȤ֤ޤ.
     *
     * @return    servlet::ServletContextؤλ.
     */
    virtual ServletConfig& getServletConfig()=0;

    /**
     * ԡСȤäServlet˴ؤ֤ޤ.
     * 
     * ǥեȤǤ϶ʸ֤ޤ. 
     *
     * @return    Сݻʸ.
     */
    virtual std::string getServletInfo()=0;
};

} // namespace servlet

#endif // SERVLET_SERVLET_H
