/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_REQUEST_DISPATCHER_H
#define SERVLET_REQUEST_DISPATCHER_H

#include <servlet/ServletException.h>

namespace servlet {

class ServletRequest;
class ServletResponse;

/**
 * @interface RequestDispatcher.
 *
 * 饤Ȥ׵¾ Servlet  HTML Υ꥽Ф
 * ׵ȤƺȯԤԤޤ.
 *
 * Servlet 鸫 RequestDispatcher ¾Υ꥽ؤŪ
 * 󥿡եǤꡢΥ꥽׵ƤǤꡢ
 * Υ꥽αǽǤ.
 */
class RequestDispatcher {
public :
    /** Destructor. */
    virtual ~RequestDispatcher();

    /**
     * RequestDispatcher ȯѥǤä
     * ȯ褬¸ߤʤϡ 줿 RequestDispatcher 
     *  null 󥹥󥹤Ȥʤ뤿ᡢؽȤƻѤޤ.
     *
     * <pre>
     *   RequestDispatcher& r = getServletContext().getRequestDispather();
     *   if (!r) {              // bool operator!() θƤӽФ
     *       :                  //  餫Υ顼
     *       :
     *       return;
     *   }
     *   r.forward(req, res);   //  ž
     * </pre>
     *
     * @return     RequestDispatcher  forward/include дؿ
     *            ¹ԲǽǤ뤫Ƚ̤֤ޤ.
     */
    virtual bool operator!() const=0;

    /**
     * @c bool @c operator!() Ʊͤ @c RequestDispatcher 󥹥󥹤
     * null 򼨤̵ʥǥѥåǤ뤫ȽԤʤ٤
     * Ѥޤ.
     * ǥեȤǤ bool operator!() ֤ޤ.
     *
     * <pre>
     *   RequestDispatcher& r = getServletContext().getRequestDispather();
     *   if (r) {                   // r.operator void*() θƤӽФ
     *       r.forward(req, res);   //  ž
     *       return;
     *   }
     *      :                       //  餫Υ顼
     *      :
     *   return;
     * </pre>
     *
     * @return     RequestDispatcher  forward/include дؿ
     *            ¹ԲǽǤ뤫Ƚ̤֤ޤ.
     *
     * @see        bool RequestDispatcher::operator!()
     */
    virtual operator const void* () const { return operator!() ? 0 : this; }

    /**
     * forward дؿθƤӽФľޤǤαƤ˴
     * ¾꥽׵žޤ.
     *
     * forward дؿθƤӽФ˱ΰޤ
     * 饤Ȥ˴ФƤ㳰򥹥ޤ.
     *
     * @param    req        饤Ȥ׵.
     * @param    res        饤Ȥؤα.
     * @throw    ServletException    žμԡڤ
     *            žǤΰ۾ȯ˥ޤ.
     */
    virtual void forward(ServletRequest& /*res*/, ServletResponse& /*req*/)
        throw(ServletException)=0;

    /**
     * include дؿθƤӽФľޤǤαƤ³ơ
     * ¾꥽׵žžαߤޤ.
     *
     * include дؿˤäƼ¹Ԥ줿 Servlet ϱΥơ
     * ѹꡢإåͤꤹ뤳ȤϤǤޤ.
     * Τ褦ʻߤ̵뤵ޤ
     *
     * @param    req        饤Ȥ׵.
     * @param    res        饤Ȥؤα.
     * @throw    ServletException    žμԡڤ
     *            žǤΰ۾ȯ˥ޤ.
     */
    virtual void include(ServletRequest& /*res*/, ServletResponse& /*req*/)
        throw(ServletException)=0;
};

} // namespace servlet

#endif // SERVLET_REQUEST_DISPATCHER_H
