/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_GENERIC_SERVLET_H
#define SERVLET_GENERIC_SERVLET_H

#include <sl/java/lang/Exception.h>
#include <sl/java/util/Enumeration.h>
#include <servlet/Servlet.h>
#include <servlet/ServletConfig.h>
#include <servlet/ServletException.h>

namespace servlet {

class ServletContext;
class ServletRequest;
class ServletResponse;

/**
 * @class GenericServlet.
 *
 * ץȥ˰¸ʤŪ Servlet Ƥޤ.
 *
 * GenericServlet  servlet::Servlet ڤ servlet::ServletConfig 饹
 * Ƥꡢдؿ initdestroy  servlet::ServletConfig 饹
 * дؿˤĤƤδʰŪʼ
 * 󶡤Ƥޤ.
 * ޤGenericServlet  servlet::ServletContext 饹Ƥ
 * log дؿμ󶡤Ƥޤ
 *
 * ŪServlet򵭽Ҥˤϡ貾۴ؿǤ service ɬ
 * ޤ.
 */
class GenericServlet
    : virtual public Servlet, virtual public ServletConfig {

public :
    /** Default Constructor. */
    GenericServlet();

    /** Destructor. */
    virtual ~GenericServlet();

    /**
     * Servlet ؤνʰŪ˹Ԥʤ󶡤줿дؿǤ.
     *
     * ̤ʽ㤨 DBؤ³򳫻Ϥꡢե륷ƥ
     * ɤ߹ߤԤʤäꤹ˥С饤ɤޤ.
     *
     * @c init() ؿ @c init(ServletConfig& config)
     * ƤӽФ @c init() ؿ򥪡С饤ɤ
     * @c init(ServletConfig& config) 򥪡С饤ɤ
     * ɬפޤ.
     *
     * @throw    ServletException    μԻ˥ޤ.
     */
    virtual void init() throw(ServletException);

    /**
     * Servlet ؤνԤʤΥдؿǤ.
     *
     * servlet::ServletConfig ɬפȤ Servlet ν
     * ԤʤˤΥдؿ򥪡С饤ɤɬפޤ
     * ξ @c GenericServlet::init(ServletConfig& config)
     * ɬ¹ԤƲ.
     *
     * @param    config        ServletConfig class instance.
     * @throw    ServletException    μԻ˥ޤ.
     * @see        Servlet::init.
     */
    virtual void init(ServletConfig& config) throw(ServletException);

    /**
     * Servlet ؤνλԤʤΥдؿǤ.
     *
     * ̤ʽλ㤨 DBؤ³Ǥꡢ㤨Хե륷ƥ
     * ؤν񤭹ߤԤʤäꤹ˥С饤ɤޤ.
     *
     * @throw    destroy дؿ㳰Фʤǲ.
     * @see        Servlet::destroy
     */
    virtual void destroy() throw();

    /**
     * Servlet 󶡤륵ӥ뤿Υ󥿡եǤ.
     *
     * service дؿ Servlet ƥʤˤäƸƤӽФ졢
     *  req ˤ׵Ф req Ȥ֤ޤ.
     *
     * service дؿϽ貾۴ؿΤޤޤʤΤ GenericServlet 
     * ѾɬС饤ɤɬפޤ.
     *
     * @param    req        饤Ȥ׵ᥪ֥.
     * @param    res        饤Ȥؤαݻ륪֥.
     * @throw    ServletException    μԻ˥ޤ.
     * @see        Servlet::service
     */
    virtual void service(ServletRequest& req, ServletResponse& res)
        throw(ServletException)=0;

    /**
     * ԡСȤäServlet˴ؤ֤ޤ.
     * 
     * ǥեȤǤ϶ʸ֤ޤ. 
     *
     * @return    Сݻʸ.
     * @see        Servlet::getServletInfo
     */
    virtual std::string getServletInfo();

    /**
     * ǻѤ servlet::ServletConfig 󥹥󥹤֤ޤ.
     * 
     * @return    servlet::ServletConfig 󥹥.
     * @see        Servlet::getServletConfig
     */
    ServletConfig& getServletConfig();

    /**
     * Web ץꥱһҤǻꤵ줿ѥ᡼
     * ̾ΥꥹȤ֤ޤ.
     *
     * Υдؿθ󶡤줿ΤǤꡢ
     * ºݤˤϡ@c init дؿݻ
     * servlet::ServletConfig ѥ᡼̾Ƥޤ.
     *
     * @return    ѥ᡼̾Υꥹ.
     * @see        ServletConfig::getInitParameterNames.
     */
    sl::java::util::Enumeration getInitParameterNames();

    /**
     * Web ץꥱһҤǻꤵ줿ѥ᡼
     * ꥹȤ顢 name ̾Ȥƻĥѥ᡼֤ͤޤ.
     *
     * Υдؿθ󶡤줿ΤǤꡢ
     * ºݤˤϡ@c init дؿݻ
     * servlet::ServletConfig ѥ᡼Ƥޤ.
     *
     * @param    name    ѥ᡼̾.
     * @return     name бѥ᡼.
     * @see        ServletConfig::getInitParameter.
     */
    std::string getInitParameter(const std::string& name);

    /**
     * servlet::ServletContext 󥹥󥹤֤ޤ. 
     *
     * Υдؿθ󶡤줿ΤǤꡢ
     * ºݤˤϡ@c init дؿݻ
     * servlet::ServletConfig  servlet::ServletContext Ƥޤ.
     *
     * @return    servlet::ServletContext 󥹥.
     * @see        ServletConfig::getServletContext
     */
    ServletContext& getServletContext();

    /**
     *  Servlet Υ󥹥󥹤֤̾ޤ.
     *
     * @return     Servlet Υ󥹥󥹤̾.
     * @see        ServletConfig::getServletName.
     */
    std::string getServletName();

    /**
     *  msg ˽Ϥޤ.
     *
     * Υдؿθ󶡤줿ΤǤꡢ
     * ºݤˤϡ@c init дؿݻ
     * servlet::ServletConfig  servlet::ServletContext 
     * @c ServletContext::log() дؿ¹Ԥޤ.
     *
     * @param    msg        å.
     * @see        ServletContext::log.
     */
    void log(const std::string& msg);

    /**
     *  e 㳰ޤ᤿Ϥޤ.
     *
     * Υдؿθ󶡤줿ΤǤꡢ
     * ºݤˤϡ@c init дؿݻ
     * servlet::ServletConfig  servlet::ServletContext 
     * @c ServletContext::log() дؿ¹Ԥޤ.
     *
     * @param    msg        å.
     * @param    e        㳰.
     * @see        ServletContext::log.
     */
    void log(const std::string& msg, const sl::java::lang::Exception& e);

private :
    ServletConfig* _servlet_config;
};

} // namespace Servlet

#endif // SERVLET_GENERIC_SERVLET_H
