/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_FILTER_CHAIN_H
#define SERVLET_FILTER_CHAIN_H

#include <servlet/ServletException.h>

namespace servlet {

class ServletRequest;
class ServletResponse;

/**
 * @interface FilterChain.
 *
 * Filter 󥹥󥹤Ф뼡Υե륿ޤϥե륿
 * λˤ Servlet 󥹥󥹤ؤθƤӽФΰ٤˻Ѥޤ.
 *
 */
class FilterChain {
public :
    /** Destructor. */
    virtual ~FilterChain()=0;

    /**
     * Υե륿ޤϥե륿νλˤ Servlet
     * 󥹥󥹤ؤθƤӽФΰ٤˻Ѥޤ.
     *
     * @param    req        FilterChain ˤäžꥯ.
     * @param    res        FilterChain ˤäž쥹ݥ.
     * @exception    FilterChain ˤž桢⤷žΰ۾ˤ
     *                㳰ȯ˥ޤ.
     */
    virtual void doFilter(ServletRequest& req, ServletResponse& res)
        throw(ServletException)=0;
};

} // namespace servlet

#endif // SERVLET_FILTER_CHAIN_H
