/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SERVLET_FILTER_H
#define SERVLET_FILTER_H

#include <servlet/ServletException.h>

namespace servlet {

class FilterChain;
class FilterConfig;
class ServletRequest;
class ServletResponse;

/**
 * @interface Filter.
 *
 * Filter Ͻ貾ۤʥ饹ǤꡢServlet ڤӤ¾ΥƥĤؤ
 * ꥯȤޤϥ쥹ݥ󥹡뤤ϤξФե륿󥰤
 * 桼ˤäƲǽȤ뤿Υ󥿡եƤޤ.
 *
 * Filter 󥹥󥹼Τ init дؿμ¹Իʳˡ
 * Servlet ƥʤΥ꥽ؤΥˡ¸ߤޤ󤬡
 * init дؿΰȤϤ servlet::FilterConfig ֥
 *  servlet::ServletContext λȤǽǤ뤿ᡢ
 * servlet::ServletContext ݻƤˤꡢ
 * Web ץꥱ¸֤ϤäƤΥ꥽ݻѹȤ
 * ǽȤʤޤ.
 *
 * ⤷ʤ Filter ǽϤΥ饹Ѿ
 * init / destroy / doFilter дؿɬפޤ.
 */
class Filter {
public :
    /** Destructor. */
    virtual ~Filter()=0;

    /**
     * Servlet ƥʤ Filter 󥹥󥹤ФȤ
     *  init дؿ¹Ԥޤ.
     *
     * Servlet ƥʤ Web ץꥱһҤ򻲾Ȥơ
     * Filter 󥹥󥹤ɤ˰٤ init дؿ
     * ¹Ԥޤ.
     * 
     * ServletException 򥹥 Filter 󥹥󥹤 doFilter 
     * ؿϼ¹Ԥ줺ޤ̾ Servlet ƥʤνλ˼¹Ԥ
     * destroy дؿ¹Ԥޤ.
     * 
     * @param    config    Servlet ƥʤݻƤ
     *                    FilterConfig 󥹥󥹤λ.
     * @exception    ServletException    Ԥꤲޤ.
     */
    virtual void init(FilterConfig& config) throw(ServletException)=0;

    /**
     * Servlet ƥʤ Filter 󥹥󥹤Ф뽪λȤ
     *  destroy дؿ¹Ԥޤ.
     *
     * ƥʤεư˥ɤ Filter 󥹥󥹤Ф 
     * ƥʤνλinit дؿdoFilter дؿ
     * ݡݻƤƼ꥽Фե륷ƥؤ
     * ¸ηȤ destroy дؿ¹Ԥޤ.
     *
     * δؿλ¨Υ󥹥󥹤Ϻޤ.
     *
     * @exception    destroy дؿ㳰Фʤǲ.
     */
    virtual void destroy() throw()=0;

    /**
     * Filter 󥹥󥹤ˤե륿󥰽¹Ԥޤ.
     * 
     * Servlet ƥʤϥ饤ȤΥꥯȼ
     * ꥯȤ URL ޥåԥ󥰤줿 Filter 󥹥󥹤򸡺
     *  Filter 󥹥󥹤¸ߤ Servlet 󥹥󥹤
     * ưΩä doFilter дؿƤӽФޤ.
     *
     * doFilter дؿ FilterChain::doFilter ؿθƤӽФˤ
     *  Filter 󥹥󥹤إꥯȤž뤳Ȥޤ.
     * ޤ餫θڤˤ۾郎ä
     * <code> FilterChain::doFilter</code> ¹Ԥˡ
     * doFilter дؿʤǥ쥹ݥ󥹤κԤʤȤ
     * ǽǤ.
     *
     * Servlet ƥʤ init дؿμ¹ڤӡ
     * destroy дؿμ¹Ը doFilter дؿ
     * ¹ԤϤޤ.
     *
     * @param    req        饤ȤΥꥯȾ
     *                    ServletRequest 󥹥.
     * @param    res        饤ȤؤΥ쥹ݥ󥹾
     *                    ServletResponse 󥹥.
     * @param    chain    Ϣ³ Filter 󥹥󥹤ݻ
     *                    FilterChain 󥹥.
     * @exception    ServletException    Ԥꤲޤ.
     */
    virtual void doFilter(ServletRequest& req, ServletResponse& res,
                          FilterChain& chain)
        throw(ServletException)=0;
};

} // namespace servlet

#endif // SERVLET_FILTER_H
