/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <servlet/ServletResponseWrapper.h>
using namespace servlet;

ServletResponseWrapper::ServletResponseWrapper(ServletResponse& response)
    : _instance(response)
{ }

ServletResponseWrapper::~ServletResponseWrapper()
{ }

sl::java::io::PrintWriter& ServletResponseWrapper::getWriter()
    throw(ServletException)
{
    return _instance.getWriter();
}

ServletOutputStream& ServletResponseWrapper::getOutputStream()
{
    return _instance.getOutputStream();
}

void ServletResponseWrapper::setContentType(const std::string& s)
{
    _instance.setContentType(s);
}

std::string ServletResponseWrapper::getContentType()
{
    return _instance.getContentType();
}


void ServletResponseWrapper::setContentLength(int i)
{
    _instance.setContentLength(i);
}

std::string ServletResponseWrapper::getCharacterEncoding()
{
    return _instance.getCharacterEncoding();
}

sl::java::util::Locale ServletResponseWrapper::getLocale()
{
    return _instance.getLocale();
}

void ServletResponseWrapper::setLocale(const sl::java::util::Locale& l)
{
    _instance.setLocale(l);
}

void ServletResponseWrapper::setBufferSize(size_t size)
{
    _instance.setBufferSize(size);
}

size_t ServletResponseWrapper::getBufferSize()
{
    return _instance.getBufferSize();
}

bool ServletResponseWrapper::isCommitted()
{
    return _instance.isCommitted();
}

void ServletResponseWrapper::flushBuffer()
{
    _instance.flushBuffer();
}

void ServletResponseWrapper::reset()
{
    _instance.reset();
}

void ServletResponseWrapper::resetBuffer()
{
    _instance.resetBuffer();
}
