/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <servlet/ServletRequestWrapper.h>
#include <servlet/RequestDispatcher.h>
#include <servlet/ServletInputStream.h>
using namespace servlet;

ServletRequestWrapper::ServletRequestWrapper(ServletRequest& request)
    : _instance(request)
{ }

ServletRequestWrapper::~ServletRequestWrapper()
{ }

sl::java::lang::Object ServletRequestWrapper::getAttribute(const std::string& s)
{
    return _instance.getAttribute(s);
}

void ServletRequestWrapper::setAttribute(const std::string& s, sl::java::lang::Object o)
{
    _instance.setAttribute(s, o);
}

void ServletRequestWrapper::removeAttribute(const std::string& s)
{
    _instance.removeAttribute(s);
}

sl::java::util::Enumeration ServletRequestWrapper::getAttributeNames()
{
    return _instance.getAttributeNames();
}

std::string ServletRequestWrapper::getParameter(const std::string& s)
{
    return _instance.getParameter(s);
}

sl::java::util::Enumeration ServletRequestWrapper::getParameterNames()
{
    return _instance.getParameterNames();
}

std::vector<std::string>
ServletRequestWrapper::getParameterValues(const std::string& name)
{
    return _instance.getParameterValues(name);
}

std::multimap<std::string, std::string> ServletRequestWrapper::getParameterMap()
{
    return _instance.getParameterMap();
}

std::string ServletRequestWrapper::getCharacterEncoding()
{
    return _instance.getCharacterEncoding();
}

void ServletRequestWrapper::setCharacterEncoding(const std::string& s)
{
    return _instance.setCharacterEncoding(s);
}

int ServletRequestWrapper::getContentLength()
{
    return _instance.getContentLength();
}

std::string ServletRequestWrapper::getContentType()
{
    return _instance.getContentType();
}

servlet::ServletInputStream& ServletRequestWrapper::getInputStream()
{
    return _instance.getInputStream();
}

sl::java::io::BufferedReader ServletRequestWrapper::getReader()
{
    return _instance.getReader();
}

sl::java::util::Locale ServletRequestWrapper::getLocale()
{
    return _instance.getLocale();
}

sl::java::util::Enumeration ServletRequestWrapper::getLocales()
{
    return _instance.getLocales();
}

std::string ServletRequestWrapper::getProtocol()
{
    return _instance.getProtocol();
}

std::string ServletRequestWrapper::getScheme()
{
    return _instance.getScheme();
}

bool ServletRequestWrapper::isSecure()
{
    return _instance.isSecure();
}

std::string ServletRequestWrapper::getServerName()
{
    return _instance.getServerName();
}

int ServletRequestWrapper::getServerPort()
{
    return _instance.getServerPort();
}

std::string ServletRequestWrapper::getLocalAddr()
{
    return _instance.getLocalAddr();
}

std::string ServletRequestWrapper::getLocalName()
{
    return _instance.getLocalName();
}

int ServletRequestWrapper::getLocalPort()
{
    return _instance.getLocalPort();
}

std::string ServletRequestWrapper::getRemoteAddr()
{
    return _instance.getRemoteAddr();
}

std::string ServletRequestWrapper::getRemoteHost()
{
    return _instance.getRemoteHost();
}

int ServletRequestWrapper::getRemotePort()
{
    return _instance.getRemotePort();
}

std::auto_ptr<RequestDispatcher>
ServletRequestWrapper::getRequestDispatcher(const std::string& s)
{
    return _instance.getRequestDispatcher(s);
}
