/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <servlet/http/HttpServlet.h>
#include <servlet/http/HttpServletRequest.h>
#include <servlet/http/HttpServletResponse.h>
using namespace servlet::http;

static const std::string exception_message = "not inplementation";

//
// Constructor/Destructor

HttpServlet::HttpServlet()
{ }


HttpServlet::~HttpServlet()
{ }


//
// Member functions
//

void HttpServlet::init() throw(ServletException)
{ }


void HttpServlet::destroy() throw()
{ }


void HttpServlet::service(ServletRequest& req, ServletResponse& res)
    throw(ServletException)
{
    HttpServletRequest*  rq = dynamic_cast<HttpServletRequest*>(&req);
    HttpServletResponse* rs = dynamic_cast<HttpServletResponse*>(&res);

    this->service(*rq, *rs);
}


void HttpServlet::service(HttpServletRequest& req, HttpServletResponse& res)
    throw(ServletException)
{
    if (req.getMethod() == "GET")
        doGet(req, res);
    else if (req.getMethod() == "POST")
        doPost(req, res);
    else if (req.getMethod() == "PUT")
        doPut(req, res);
    else if (req.getMethod() == "DELETE")
        doDelete(req, res);
    else if (req.getMethod() == "HEAD")
        doHead(req, res);
    else if (req.getMethod() == "OPTIONS")
        doOptions(req, res);
    else if (req.getMethod() == "TRACE")
        doTrace(req, res);
    else
        throw ServletException("unknown method :" + req.getMethod());
}


void HttpServlet::doGet(HttpServletRequest&, HttpServletResponse&)
    throw(ServletException)
{ throw ServletException(exception_message); }


void HttpServlet::doPost(HttpServletRequest&, HttpServletResponse&)
    throw(ServletException)
{ throw ServletException(exception_message); }


void HttpServlet::doPut(HttpServletRequest&, HttpServletResponse&)
    throw(ServletException)
{ throw ServletException(exception_message); }


void HttpServlet::doHead(HttpServletRequest&, HttpServletResponse&)
    throw(ServletException)
{ throw ServletException(exception_message); }


void HttpServlet::doDelete(HttpServletRequest&, HttpServletResponse&)
    throw(ServletException)
{ throw ServletException(exception_message); }


void HttpServlet::doTrace(HttpServletRequest&, HttpServletResponse&)
    throw(ServletException)
{ throw ServletException(exception_message); }


void HttpServlet::doOptions(HttpServletRequest&, HttpServletResponse&)
    throw(ServletException)
{ throw ServletException(exception_message); }
