/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <string>
using namespace std;

#include <servlet/GenericServlet.h>
#include <servlet/ServletContext.h>
using namespace servlet;


//
// Constructor/Destructor
//

GenericServlet::GenericServlet()
{ }


GenericServlet::~GenericServlet()
{ }



//
//
// Member functions
//

void GenericServlet::init(ServletConfig& config) throw(ServletException)
{
    _servlet_config = &config;
    this->init();
}


void GenericServlet::init() throw(ServletException)
{ }


void GenericServlet::destroy() throw()
{ }


ServletConfig& GenericServlet::getServletConfig()
{
    return *_servlet_config;
}


string GenericServlet::getServletInfo()
{
    return "";
}


sl::java::util::Enumeration GenericServlet::getInitParameterNames()
{
    return _servlet_config->getInitParameterNames();
}


string GenericServlet::getInitParameter(const string& s)
{
    return _servlet_config->getInitParameter(s);
}


ServletContext& GenericServlet::getServletContext()
{
    return _servlet_config->getServletContext();
}


string GenericServlet::getServletName()
{
    return _servlet_config->getServletName();
}


void GenericServlet::log(const string& msg)
{
    _servlet_config->getServletContext().log(getServletName() + " " + msg);
}


void GenericServlet::log(const string& msg, const sl::java::lang::Exception& e)
{
    _servlet_config->getServletContext().log(getServletName() + " " + msg, e);
}
