/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <servlet/http/Cookie.h>
using namespace servlet::http;

Cookie::Cookie(const std::string& name, const std::string& value)
    throw (sl::java::lang::IllegalArgumentException)
{
    // ̾ RFC 2109 ˽äΤǤʤФʤʤ.
    if (name.find(" ") != std::string::npos ||
        name.find(":") != std::string::npos ||
        name.find(";") != std::string::npos)
        throw sl::java::lang::IllegalArgumentException("invalid string no RFC2109");

    _name  = name;
    _value = value;
}


std::string Cookie::getName() const
{ return _name; }

std::string Cookie::getValue() const
{ return _value; }

void Cookie::setValue(const std::string& v)
{ _value = v; }

std::string Cookie::getComment() const
{ return _comment; }

void Cookie::setComment(const std::string& s)
{ _comment = s; }

std::string Cookie::getDomain() const
{ return _domain; }

void Cookie::setDomain(const std::string& s)
{ _domain = s; }

int Cookie::getMaxAge() const
{ return _age; }

void Cookie::setMaxAge(int i)
{ _age = i; }

std::string Cookie::getPath() const
{ return    _uri; }

void Cookie::setPath(const std::string& s)
{ _uri = s; }

bool Cookie::getSecure() const
{ return _secure; }

void Cookie::setSecure(bool flag)
{ _secure = flag; }

int Cookie::getVersion() const
{ return _version; }

void Cookie::setVersion(int v)
{ _version = v; }
