/*-
 * Copyright (c) 2005 osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <servlet/jsp/tagext/TagSupport.h>
using namespace servlet::jsp;
using namespace servlet::jsp::tagext;


//
// Constructor/Destructor
//

TagSupport::TagSupport()
    : _parent_tag(0)
{ }


TagSupport::~TagSupport()
{ }


//
// Member functions.
//

int TagSupport::doAfterBody() throw(JspException)
{
    return 0;
}


int TagSupport::doStartTag() throw(JspException)
{
    return 0;
}


int TagSupport::doEndTag() throw(JspException)
{
    return 0;
}


void TagSupport::release()
{ }


void TagSupport::setPageContext(PageContext& context)
{
    pageContext = &context;
}

std::string TagSupport::getId()
{
    return _id;
}


void TagSupport::setId(const std::string& id)
{
    _id = id;
}


Tag& TagSupport::getParent()
{
    return *_parent_tag;
}


void TagSupport::setParent(Tag& tag)
{
    _parent_tag = &tag;
}


sl::java::lang::Object TagSupport::getValue(const std::string& k)
{
    value_map_t::iterator i = _value_map.find(k);
    if (i != _value_map.end())
        return i->second;

    return sl::java::lang::Object();
}

std::vector<sl::java::lang::Object> TagSupport::getValues()
{
    std::vector<sl::java::lang::Object> object_list;

    value_map_t::iterator i = _value_map.begin();
    for (; i != _value_map.end(); i++)
        object_list.push_back(i->second);

    return object_list;
}


void TagSupport::setValue(const std::string& k, sl::java::lang::Object o)
{
    _value_map.insert(value_map_t::value_type(k, o));
}
