/*-
 * Copyright (c) 2005 osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <servlet/jsp/tagext/SimpleTagSupport.h>
using namespace servlet::jsp;
using namespace servlet::jsp::tagext;


void SimpleTagSupport::doTag() throw(JspException)
{
}

JspTag& SimpleTagSupport::getParent()
{
    return *_parent;
}

void SimpleTagSupport::setParent(JspTag& t)
{
    _parent = &t;
}

void SimpleTagSupport::setJspBody(JspFragment& body)
{
    _fragment = &body;
}

void SimpleTagSupport::setJspContext(JspContext& context)
{
    _context = &context;
}


// static
JspTag& SimpleTagSupport::findAncestorWithClass(JspTag& from,
                                                sl::java::lang::Class c)
{

}


// protected

JspFragment& SimpleTagSupport::getJspBody()
{
    return *_fragment;
}

JspContext& SimpleTagSupport::getJspContext()
{
    return *_context;
}
