#!/bin/sh
#
# Copyright (c) 2008 Masashi Osakabe
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: gen_config.sh,v 1.15 2008/03/13 13:58:55 cvsuser Exp $
#

info=".information"
curdir=
topdir=
builddir=
arg1=
runcmd=all
batch=no
autoscan=
autoconf=
autoheader=
automake=
aclocal=
libtoolize=


# ----- current directories -----
curdir=`pwd`
echo $curdir | grep build$ > /dev/null
if test $? = 0 ; then
	topdir=`dirname $curdir`
	builddir=$curdir
else
	topdir=$curdir
	builddir=$topdir/build
fi
cd $topdir


# ----- include information files -----
. `pwd`/$info

pkg_ver=`echo $version | sed 's/\([0-9]*\.[0-9]*\).*/\1/'`

deplibs()
{
	IFS=$save_ifs
	__r=1

	for __d in $depend_libraries
	do
		if test "$__d" = "$1" ; then
			__r=0
			break;
		fi
	done

	IFS=
	return $__r
}



# ----- parse arguments -----
parse_argument()
{
	if test $arg1 = --help || test $arg1 = -h ; then
		echo "Usage: ${0} [action"
		echo "action:"
		echo "  -h, --help              display this help and exit"
		echo "  -v, --version           display information and exit"
		echo "  -as, --autoscan         run autoscan only"
		echo "  -ac, --autoconf         run autoconf only"
		echo "  -ah, --autoheader       run autoheader only"
		echo "  -al, --aclocal          run aclocal only"
		echo "  -am, --automake         run automake only"
		echo "  -lt, --libtoolize       run libtoolize only"
		echo "  -c, --clean             erase all configuration files"
		echo "  -b, --batch             if more exists program, choose new timestanp program"
		exit 0
	fi

	if test $arg1 = --version || test $arg1 = -v ;then
		echo "build information file :\`$topdir/$info'"
		echo "name    :$name"
		echo "version :$version"
		echo "pkg_ver :$pkg_ver"
		echo "address :$address"
		echo "depend libraries  :$depend_libraries"
		exit 0

	elif test $arg1 = -as || test $arg1 = --autoscan ; then
		echo "only autoscan run."
		runcmd="autoscan"
		return

	elif test $arg1 = -ac || test $arg1 = --autoconf ; then
		echo "only autoconf run."
		runcmd="autoconf"
		return

	elif test $arg1 = -ah || test $arg1 = --autoheader ; then
		echo "only autoheader run."
		runcmd="autoheader"
		return

	elif test $arg1 = -al || test $arg1 = --aclocal ; then
		echo "only aclocal run."
		runcmd="aclocal"
		return

	elif test $arg1 = -am || test $arg1 = --automake ; then
		echo "only automake run."
		runcmd="automake"
		return

	elif test $arg1 = -lt || test $arg1 = --libtoolize ; then
		echo "only libtoolize run."
		runcmd="libtoolize"
		return

	elif test $arg1 = -c || test $arg1 = --clean ; then
		echo "erase all configuration files"
		runcmd="clean"
		return
	elif test $arg1 = -b || test $arg1 = --batch ; then
		echo "choose default ..."
		batch="yes"
		return
	else
		echo "\`$arg1' is not defined."
		echo "Try \`${0} --help' for more information."
		exit 0
	fi
}


if test "x"$1 != "x" ; then
	arg1=$1
else
	arg1="all"
fi

if test $arg1 != all ; then
	parse_argument;
else
	runcmd="all"
fi


# ----- find autotools -----
find_commands()
{
	target=${1}
	path=`echo ${PATH} | tr ":" "\n" | sort | uniq | tr "\n" " "`
	result=
	num=

	for __i in $path
	do
		if test ! -d $__i ; then
			continue
		fi

		__t=`ls $__i | grep -E "^$target*"`
		if test $? = 0 ; then
			count=`echo $__t | wc -w`
			if test $count = 1 ; then
				result="$result $__i/$__t"
			else
				for __j in $__t
				do
					result="$result $__i/$__j"
				done
			fi
		fi
	done

	count=`echo $result | wc -w`
	if test $count = 0 ; then
		echo "*** Error \`$target' is not exist."
		exit 1
	elif test $count != 1 ; then
		echo "*** Warning \`$target*' is two or more exists."
		while true
		do
			default_num=1
			__n=1
			__f=
			for __i in $result
			do
				echo "  $__n :$__i"

				if test "x"$__f = "x"; then
					__f=$__i
				elif test $__f -ot $__i; then
					__f=$__i
					default_num=$__n
				fi

				__n=`expr $__n + 1`
			done

			if test $batch != yes ; then
				echo -n "Please choose the number(default is $default_num)> "
				read num
			else
				num=
			fi
			if test "x"$num = "x" ; then
				num=$default_num
			fi
			echo $num | grep -E '^[0-9]*$' > /dev/null
			if test $? = 0 ; then
				break;
			else
				echo "The value is not an integer."
			fi
		done

		__n=1
		for __i in $result
		do
			if test $num = $__n ; then
				__t=$__i
			fi
			__n=`expr $__n + 1`
		done

		if test "x"$__t = "x" ; then
			echo "*** Error There is no such number."
			exit 2
		fi
	else
		__t=$result
	fi

	# trim spaces
	__t=`echo $__t | sed 's/^[ ]*//g' | sed 's/[ ]$//g'`

	if test ${1} = "autoscan" ; then
		autoscan=$__t
	fi
	if test ${1} = "autoconf" ; then
		autoconf=$__t
	fi
	if test ${1} = "autoheader" ; then
		autoheader=$__t
	fi
	if test ${1} = "automake" ; then
		automake=$__t
	fi
	if test ${1} = "aclocal" ; then
		aclocal=$__t
	fi
	if test ${1} = "libtoolize" ; then
		libtoolize=$__t
	fi
}


if test $runcmd = autoscan || test $runcmd = all ; then
	find_commands "autoscan"
	echo "autoscan    :$autoscan"
fi

if test $runcmd = autoheader || test $runcmd = all ; then
	find_commands "autoheader"
	echo "autoheader  :$autoheader"
fi

if test $runcmd = autoconf || test $runcmd = all ; then
	find_commands "autoconf"
	echo "autoconf    :$autoconf"
fi

if test $runcmd = automake || test $runcmd = all ; then
	find_commands "automake"
	echo "automake    :$automake"
fi

if test $runcmd = aclocal || test $runcmd = all ; then
	find_commands "aclocal"
	echo "aclocal     :$aclocal"
fi

if test $runcmd = libtoolize || test $runcmd = all ; then
	find_commands "libtoolize"
	echo "libtoolize :$libtoolize"
fi


# ----- first cleanup -----
#rm -f `find $topdir/ | grep -E 'Makefile.in$'`


# ----- autoscan -----
output_infile()
{
	echo -n "AC_OUTPUT([" >> $tmp_file
	IFS=$save_ifs
	for i in $infile
	do
		echo -n "$i " >> $tmp_file
	done
	echo "])" >> $tmp_file
	IFS=
}


if test $runcmd = autoscan || test $runcmd = all ; then
	echo "run $autoscan ..."

	rm -f $topdir/configure.in
	rm -f $topdir/configure.scan
	rm -f $topdir/autoscan*.log

	input=configure.scan
	output=configure.in
	tmp_file=.configure.tmp
	rm -f $input
	rm -f $output
	rm -f $tmp_file
	touch $topdir/configure.ac

	$autoscan
	if test $? != 0 ;then
		echo "*** Error $autoscan failed."
		exit 1
	fi

	rm configure.ac

	save_ifs=$IFS
	IFS=
	while read __i
	do
		echo $__i | grep -E '^AC_INIT' > /dev/null
		if test $? = 0 ; then
			echo $__i | sed "s/FULL-PACKAGE-NAME/$name/g" | \
					  sed "s/VERSION/$version/g" | \
					  sed "s/BUG-REPORT-ADDRESS/$address/g" >> $tmp_file
			echo "AC_CONFIG_AUX_DIR(build)" >> $tmp_file
			echo "AM_INIT_AUTOMAKE($name, $version, $address)" >> $tmp_file
			echo "PACKAGE_VERSION=$pkg_ver" >> $tmp_file
    		echo "AC_SUBST(PACKAGE_VERSION)" >> $tmp_file
			continue
		fi
	
		echo $__i | grep -E 'AC_CONFIG_HEADER' > /dev/null
		if test $? = 0 ; then
			#echo $__i | sed "s/^AC/AM/" >> $tmp_file
			echo $__i >> $tmp_file
			continue
		fi
	
		echo $__i | grep -E '^AC_PROG_CXX' > /dev/null
		if test $? = 0 ; then
#			echo "AX_CXXFLAGS" >> $tmp_file
			echo "AC_LIBTOOL_DLOPEN" >> $tmp_file
			echo "AC_PROG_LIBTOOL" >> $tmp_file
			echo $__i >> $tmp_file
			continue
		fi
	
		echo $__i | grep -E '^AC_PROG_RANLIB' > /dev/null
		if test $? = 0 ; then
			continue
		fi
	
		echo $__i | grep -E 'Checks for libraries.' > /dev/null
		if test $? = 0 ; then
			echo "AX_CXXFLAGS" >> $tmp_file

			echo $__i >> $tmp_file
			if deplibs "boost"; then
				echo "AX_BOOST(1.32,, AC_MSG_ERROR([*** Boost 1.32 or higher is required]))" >> $tmp_file
			fi
			if deplibs "openssl"; then
				echo "AX_OPENSSL(0.00,, AC_MSG_ERROR([*** OpenSSL 0.00 or higher is required]))" >> $tmp_file
			fi
			if deplibs "expat"; then
				echo "AX_EXPAT(1.98,, AC_MSG_ERROR([*** Expat 1.98 or higher is required]))" >> $tmp_file
			fi
			if deplibs "execinfo"; then
				echo "AX_EXECINFO" >> $tmp_file
			fi
			if deplibs "sl"; then
				echo "AX_SL(0.10,, AC_MSG_ERROR([*** si libraries 0.10 or higher is required]))" >> $tmp_file
			fi
			if deplibs "servlet"; then
				echo "AX_SERVLET(0.10,, AC_MSG_ERROR([*** cpp-servlet-api 0.10 or higher is required]))" >> $tmp_file
			fi
			if deplibs "si"; then
				echo "AX_SI" >> $tmp_file
				echo "AX_SI_INSTDIR" >> $tmp_file
			fi
			continue
		fi
	
		#
		# ----- skip lines -----
		#
		echo $__i | grep -E 'FIXME: ' > /dev/null
		if test $? = 0 ; then
			continue;
		fi
		echo $__i | grep -E 'AC_CHECK_LIB' > /dev/null
		if test $? = 0 ; then
			continue;
		fi

		#
		# ----- edit AC_CONFIG_FILES -----
		#
		echo $__i | grep -E 'webapps/' > /dev/null
		if test $? = 0 ; then
			echo $__i | grep ')' > /dev/null
			if test $? = 0 ; then
				echo "])" >> $tmp_file
			fi
			continue
		fi	

		#
		# configure : AC_OUTPUT
		#
		echo $__i | grep -E 'AC_OUTPUT' > /dev/null
		if test $? = 0 ; then
			output_infile
			continue;
		fi

		echo $__i >> $tmp_file
	
	done < $input

	mv $tmp_file $output

	rm -f $topdir/configure.scan
	rm -f $topdir/autoscan*.log

	IFS=$save_ifs
fi


# ----- libtoolize -----
if test $runcmd = libtoolize || test $runcmd = all ; then
	echo "run $libtoolize ..."

	rm -f $builddir/config.guess
	rm -f $builddir/config.sub
	rm -f $builddir/ltmain.sh

	$libtoolize --force --copy
	if test $? != 0 ;then
		echo "*** Error $libtoolize failed."
		exit 1
	fi
fi


# ----- aclocal -----
if test $runcmd = aclocal || test $runcmd = all ; then
	echo "run $aclocal ..."

	rm -fr $topdir/autom4te*.cache
	rm -f $topdir/aclocal*.m4

	$aclocal -I $builddir
	if test $? != 0 ;then
		echo "*** Error $aclocal failed."
		exit 1
	fi
fi


# ----- autoheader -----
if test $runcmd = autoheader || test $runcmd = all ; then
	echo "run $autoheader ..."

	rm -f config.h.in*

	$autoheader
	if test $? != 0 ;then
		echo "*** Error $autoheader failed."
		exit 1
	fi
fi


# ----- automake -----
if test $runcmd = automake || test $runcmd = all ; then
	echo "run $automake ..."

	rm -f $builddir/depcomp
	rm -f $builddir/install-sh
	rm -f $builddir/missing
	rm -f $builddir/mkinstalldirs
	for i in `find $topdir/ | grep -E 'Makefile.in$'`
	do
		rm -f $i
	done

	if test ! -f $topdir/INSTALL ; then
		touch $topdir/INSTALL
	fi
	if test ! -f $topdir/NEWS ; then
		touch $topdir/NEWS
	fi
	if test ! -f $topdir/README ; then
		touch $topdir/README
	fi
	if test ! -f $topdir/AUTHORS ; then
		touch $topdir/AUTHORS
	fi
	if test ! -f $topdir/ChangeLog ; then
		touch $topdir/ChangeLog
	fi
	if test ! -f $topdir/COPYING ; then
		touch $topdir/COPYING
	fi

	$automake -a -c
	if test $? != 0 ;then
		echo "*** Error $automake failed."
		exit 1
	fi
fi


# ----- autoconf -----
if test $runcmd = autoconf || test $runcmd = all ; then
	echo "run $autoconf ..."

	rm -f $topdir/configure

	$autoconf
	if test $? != 0 ;then
		echo "*** Error $autoconf failed."
		exit 1
	fi
fi


# ----- cleanup -----
if test $runcmd = clean ; then
	echo "clean ..."

	set -x
	for i in `find $topdir/ | grep -E 'Makefile.in$'`
	do
		rm -f $i
	done

	rm -f $topdir/configure.in
	rm -f $topdir/autoscan*.log
	rm -f $topdir/configure.scan
	rm -f $topdir/configure.lineno

	rm -f $builddir/config.guess
	rm -f $builddir/config.sub
	rm -f $builddir/ltmain.sh

	rm -fr $topdir/autom4te*.cache
	rm -f $topdir/aclocal*.m4

	rm -f $builddir/depcomp
	rm -f $builddir/install-sh
	rm -f $builddir/missing
	rm -f $builddir/mkinstalldirs
	for i in `find $topdir/ | grep -E 'Makefile.in$'`
	do
		rm -f $i
	done

	if test ! -s $topdir/INSTALL ; then
		rm -f $topdir/INSTALL
	fi
	if test ! -s $topdir/NEWS ; then
		rm -f $topdir/NEWS
	fi
	if test ! -s $topdir/README ; then
		rm -f $topdir/README
	fi
	if test ! -s $topdir/AUTHORS ; then
		rm -f $topdir/AUTHORS
	fi
	if test ! -s $topdir/ChangeLog ; then
		rm -f $topdir/ChangeLog
	fi
	if test ! -s $topdir/COPYING ; then
		rm -f $topdir/COPYING
	fi

	rm -f $topdir/config.h.in*

	rm -f $topdir/config.h
	rm -f $topdir/configure
	rm -f $topdir/config.log
	rm -f $topdir/config.status
	rm -f $topdir/stamp-h*
	rm -f $topdir/libtool
fi
