#*-
# Copyright (c) 2008 Masashi Osakabe
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: ax_expat.m4,v 1.2 2008/01/25 16:22:50 cvsuser Exp $
#
#
# --with-expat={directory}
#
# AX_EXPAT([MINIMUM-VERSION], [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# configure.in
#   :AC_SUBST(EXPAT_CPPFLAGS)
#   :AC_SUBST(EXPAT_LDFLAGS)
#   :AC_SUBST(EXPAT_LIB)
#
# config.h.in
#   :HAVE_EXPAT
#

AC_DEFUN([AX_EXPAT],
[
	AC_ARG_WITH([expat],
				AS_HELP_STRING([--with-expat=DIR],
				[use expat (default is yes) specify the root directory for expat library (optional)]),
				[
				if test "$withval" = "no"; then
					want_expat="no"
				elif test "$withval" = "yes"; then
					want_expat="yes"
					ac_expat_path=""
				else
					want_expat="yes"
					ac_expat_path="$withval"
				fi
				],
				[want_expat="yes"])

	if test "x$want_expat" = "xyes"; then
		AC_REQUIRE([AC_PROG_CC])
		AC_MSG_CHECKING(for expat.h)

		if test "$ac_expat_path" != ""; then
			EXPAT_CPPFLAGS="-I$ac_expat_path/include"
			EXPAT_LDFLAGS="-L$ac_expat_path/lib"
		else
			for ac_expat_path_tmp in /usr /usr/local /usr/pkg /opt ; do
				if test -d "$ac_expat_path_tmp" && test -r "$ac_expat_path_tmp/include/expat.h"; then
					EXPAT_CPPFLAGS="-I$ac_expat_path_tmp/include"
					EXPAT_LDFLAGS="-L$ac_expat_path_tmp/lib"
					break;
				fi
			done
		fi

		if test "$EXPAT_CPPFLAGS" = "";then
			AC_MSG_RESULT(no)
			AC_MSG_WARN('*** expat.h does not exist')
		else
			AC_MSG_RESULT(yes)

			CPPFLAGS="$CPPFLAGS $EXPAT_CPPFLAGS"
			export CPPFLAGS
			LDFLAGS="$LDFLAGS $EXPAT_LDFLAGS"
			export LDFLAGS

			AC_SUBST(EXPAT_CPPFLAGS)
			AC_SUBST(EXPAT_LDFLAGS)

			ax_lib=expat
			AC_CHECK_LIB($ax_lib, XML_ParserCreate, [EXPAT_LIB="-l$ax_lib";
				AC_SUBST(EXPAT_LIB) link_expat="yes";break], [link_expat="no"])
			if test "x$link_expat" = "xno"; then
				AC_MSG_ERROR(Could not link against lib$ax_lib !)
			else
				AC_DEFINE(HAVE_EXPAT, ,
					[Define to 1 if the libexpat is available])
			fi
		fi
	fi
])
