/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_SERVLET_JSP_WRAPPER_H
#define SJ_SERVLET_JSP_WRAPPER_H

#include <string>
#include <servlet/Servlet.h>

#include <si/interface/Config.h>
#include <si/interface/Context.h>
#include <si/interface/Valve.h>
#include <si/interface/ServletWrapper.h>
#include <si/core/RequestDispatcherImpl.h>
#include <si/core/ServletConfigImpl.h>
#include <si/core/ServletContextImpl.h>


class JspWrapper : virtual public ServletWrapper {

    typedef std::vector<std::string>            mapping_list_t;
    typedef std::map<std::string, std::string>  mimetype_map_t;
    typedef std::map<std::string, std::string>  init_para_map_t;

public :
    JspWrapper();

    virtual ~JspWrapper();

    virtual bool operator!() const;

    virtual void config(const si::interface::Config& c);

    virtual si::interface::Config config() const;

    virtual void name(const std::string &name);

    virtual std::string name() const;

    virtual void className(const std::string &name);

    virtual std::string className() const;

    virtual void home(const std::string &home);

    virtual std::string home() const;

    virtual void setParent(si::interface::Base* context);

    virtual si::interface::Base* getParent() const;

    virtual void
    setLoader(const boost::shared_ptr<si::interface::Loader>& loader);

    virtual boost::shared_ptr<si::interface::Loader> getLoader() const;

    virtual void setLogger(const boost::shared_ptr<si::interface::Logger>& logger);

    virtual boost::shared_ptr<si::interface::Logger> getLogger() const;

    virtual boost::shared_ptr<si::interface::Logger>
    loadLogger(const si::interface::Config&);

    virtual void setRealm(const boost::shared_ptr<si::interface::Realm>& realm);

    virtual boost::shared_ptr<si::interface::Realm> getRealm() const;

    virtual void docBase(const std::string &docBase);

    virtual std::string docBase();

    virtual void servletClassPath(const std::string &path);

    virtual std::string servletClassPath();

    virtual void servletClassName(const std::string &name);

    virtual std::string servletClassName();

    virtual void setManager(boost::shared_ptr<Manager> manager);

    virtual boost::shared_ptr<Manager> getManager();

    virtual servlet::ServletContext& getServletContext();

    virtual void setServletContext(servlet::ServletContext&);

    virtual void addMapping(const std::string &s);

    virtual void addInitParam(const std::string &n, const std::string &v);

    virtual std::vector<std::string> getMapping();

    virtual bool match(const std::string &pattern) const;

    virtual time_t invokeTime();

    virtual void loadInstance();

    virtual void unloadInstance();

    virtual void init();

    virtual void destroy();

    virtual void service(Connection *p);

    virtual void service(servlet::ServletRequest&, servlet::ServletResponse&);

    virtual servlet::Servlet *instance();

    virtual void addValve(boost::shared_ptr<Valve> v) { }

    virtual std::vector<boost::shared_ptr<Valve> > getValve() const
    { return std::vector<boost::shared_ptr<Valve> >();  }

private :
    bool _available;
    time_t _invoke;
    std::string _home;
    std::string _doc_base;
    std::string _name;
    std::string _class_path;
    std::string _class_name;

    /** 饹̾ȤƻѽʤʸִŪʥ饹̾. */
    std::string _replace_name;
    mapping_list_t _mapping_list;
    mimetype_map_t _mimetype_map;
    init_para_map_t _init_para_map;

    si::interface::Base* _parent;
    si::interface::Context* _context;
    boost::shared_ptr<si::interface::Manager> _manager;
    boost::shared_ptr<si::interface::Loader> _loader;
    boost::shared_ptr<si::interface::Logger> _logger;
    boost::shared_ptr<si::interface::Realm> _realm;
    si::interface::Config _config;

    servlet::ServletContext* _servlet_context;
    servlet::ServletConfig* _servlet_config;
    boost::shared_ptr<servlet::Servlet> _sp1;
    boost::shared_ptr<servlet::Servlet> _sp2;

    si::core::RequestDispatcherImpl* _dispatcher;
};


#endif // SJ_SERVLET_JSP_WRAPPER_H
