/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <string>
#include <boost/regex.hpp>
using namespace std;
using namespace boost;

#include <sl/java/lang/ClassLoader.h>
#include <sl/java/lang/String.h>

#include <si/interface/Config.h>
#include <si/interface/Connection.h>
#include <si/interface/Loader.h>
#include <si/interface/Logger.h>
#include <si/interface/Manager.h>
#include <si/interface/Request.h>
#include <si/interface/Response.h>
#include <si/core/HttpServletRequestImpl.h>
#include <si/core/HttpServletResponseImpl.h>
#include <si/core/RequestDispatcherImpl.h>
#include <si/core/ServletConfigImpl.h>
#include <si/core/ServletContextImpl.h>
using namespace si::interface;
using namespace si::core;

#include <servlet/http/HttpServlet.h>
#include <servlet/GenericServlet.h>
#include <servlet/jsp/HttpJspPage.h>

#include "JspWrapper.h"


//
// Constructor/Destructor.
//


JspWrapper::JspWrapper()
    : _servlet_context(0), _servlet_config(0), _dispatcher(0)
{
}

JspWrapper::~JspWrapper()
{
}


//
// Member functions.
//

bool JspWrapper::operator!() const
{
    return _available;
}


void JspWrapper::config(const si::interface::Config& c)
{
    _config = c;
}


Config JspWrapper::config() const
{
    return _config;
}


void JspWrapper::home(const string &home)
{
    _home = home;
}


string JspWrapper::home() const
{
    return _home;
}


void JspWrapper::docBase(const string &docBase)
{
    _doc_base = docBase;
}


string JspWrapper::docBase()
{
    return _doc_base;
}


void JspWrapper::name(const string &name)
{
    _name = name;
}


string JspWrapper::name() const
{
    return _name;
}

void JspWrapper::className(const string &name)
{
    _class_name = name;
}


string JspWrapper::className() const
{
    return _class_name;
}


void JspWrapper::servletClassPath(const string &path)
{
    _class_path = path;
}


string JspWrapper::servletClassPath()
{
    return _class_path;
}


void JspWrapper::servletClassName(const string &name)
{
    _class_name = name;
}


string JspWrapper::servletClassName()
{
    return _class_name;
}


void JspWrapper::setLoader(const boost::shared_ptr<Loader>& loader)
{
    _loader = loader;
}


boost::shared_ptr<Loader> JspWrapper::getLoader() const
{
    return _loader;
}


void JspWrapper::setLogger(const boost::shared_ptr<Logger>& logger)
{
    _logger = logger;
}


boost::shared_ptr<Logger> JspWrapper::getLogger() const
{
    return _logger;
}

boost::shared_ptr<Logger> JspWrapper::loadLogger(const si::interface::Config&)
{
    return _logger;
}


void JspWrapper::setRealm(const boost::shared_ptr<Realm>& realm)
{
    _realm = realm;
}


boost::shared_ptr<Realm> JspWrapper::getRealm() const
{
    return _realm;
}


void JspWrapper::setParent(Base *context)
{
    _parent = context;//dynamic_cast<Context *>(context);
}


Base* JspWrapper::getParent() const
{
    return _parent;
}


void JspWrapper::setManager(boost::shared_ptr<Manager> manager)
{
    _manager = manager;
}


boost::shared_ptr<Manager> JspWrapper::getManager()
{
    return _manager;
}


servlet::ServletContext& JspWrapper::getServletContext()
{
    return *_servlet_context;
}


void JspWrapper::setServletContext(servlet::ServletContext& c)
{
    _servlet_context = &c;
}


void JspWrapper::addMapping(const string &pattern)
{
    _mapping_list.push_back(pattern);
}


vector<string> JspWrapper::getMapping()
{
    return _mapping_list;
}


bool JspWrapper::match(const string &uri) const
{
    using namespace boost;

    if (uri == _class_name)
        return true;
    return false;
}


void JspWrapper::addInitParam(const string &n, const string &v)
{
    _init_para_map.insert(init_para_map_t::value_type(n, v));
}


time_t JspWrapper::invokeTime()
{
    return _invoke;
}

void JspWrapper::loadInstance()
{ }


void JspWrapper::unloadInstance()
{ }

void JspWrapper::init()
{
    if (!_context)
        _context = dynamic_cast<si::interface::Context*>(_parent);

    if (_class_path.empty() || _class_name.empty()) {
        cerr<< "Servlet class file or class name is not set." << endl;
        throw std::runtime_error("Servlet class file or name is not set.");
    }

    if (!_parent) {
        cerr<< "std::runtime_error, Context is not set." << endl;
        throw std::runtime_error("std::runtime_error, Context is not set.");
    }

"XXXXX";
#if 0
    if (!_manager) {
        cerr<< "std::runtime_error, Manager is not set." << endl;
        throw std::runtime_error(
                            "std::runtime_error, Manager is not set.");
    }
#endif

    if (!getLogger()) {
        cerr<< "std::runtime_error, Logger is not set." << endl;
        throw std::runtime_error("JspWrapper init failed. Logger is not set.");
    }

    // ¸ߤʤϿƤΥѤ.
    if (!_loader)
        _loader = _parent->getLoader();

    //
    // ServletConfig μ饹󥹥󥹤.
    //
    ServletConfigImpl *c = new ServletConfigImpl();
    c->setServletContext(_servlet_context);
    _servlet_config = c;

    try {

"XXXXX";
        if (chdir(_class_path.c_str()) != 0)
            throw std::runtime_error("JspWrapper init failed. can't load Servlet.");

        sl::java::lang::Class clazz = _loader->loadClass(_class_name);
        _sp1 = clazz.newInstance<servlet::Servlet>();
        if (!_sp1)
            throw std::runtime_error("JspWrapper init failed. can't load Servlet.");

        if (chdir(home().c_str()) != 0)
            throw std::runtime_error("JspWrapper init failed. can't load Servlet.");

        /*
         * servlet::Servlet Ȥƥɤ󥹥󥹤ηѾطĴ٤
         * GenericServlet ⤷ HttpJspPage Υ󥹥󥹤Ǥ
         * η˥㥹Ȥݥ󥿤ݻƤ
         */
        servlet::jsp::HttpJspPage* http_jsp =
                    dynamic_cast<servlet::jsp::HttpJspPage*>(_sp1.get());
        if (http_jsp) {
            _sp2 = boost::shared_ptr<servlet::Servlet>(http_jsp);
        } else {
            servlet::GenericServlet *generic =
                    dynamic_cast<servlet::GenericServlet*>(_sp1.get());
            if (generic) {
                _sp2 = boost::shared_ptr<servlet::Servlet>(generic);
            } else {
                cerr << "Unknown Servlet instance." << endl;
            }
        }
        _sp2->init(*_servlet_config);

    } catch (sl::java::lang::ClassNotFoundException& e) {
        getLogger()->log("JspWrapper::init failed.", e);
        return;
    } catch (sl::java::lang::InstantiationException& e) {
        getLogger()->log("JspWrapper::init failed.", e);
        return;
    } catch (std::runtime_error& e) {
        getLogger()->log("JspWrapper::init failed.", e);
        return;
    }

    _invoke = ::time(0);
    _available = true;
}


void JspWrapper::destroy()
{
    _sp1 = boost::shared_ptr<servlet::Servlet>();
    _sp2 = boost::shared_ptr<servlet::Servlet>();
    _loader->unloadClass(_class_path + _replace_name);

    delete _servlet_config;
}


void JspWrapper::service(Connection *connect)
{
    HttpServletResponseImpl    servlet_response(*connect, *_context);
    HttpServletRequestImpl    servlet_request(*connect, *_context);

    service(servlet_request, servlet_response);
}

void JspWrapper::service(servlet::ServletRequest& req,
                         servlet::ServletResponse& res)
{
    try {
        if (_sp2)
            _sp2->service(req, res);
    } catch(servlet::ServletException &e) {
        cerr << e.what() << endl;
        dynamic_cast<servlet::http::HttpServletResponse&>(res).setStatus(500);
    }
}

servlet::Servlet *JspWrapper::instance()
{
    if (!_available || !_sp2) {
        cerr<< "std::runtime_error, Unavailable." << endl;
        throw std::runtime_error("std::runtime_error, Unavailable.");
    }

    return _sp2.get();
}
