/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_SERVLET_JSP_SERVLET_H
#define SJ_SERVLET_JSP_SERVLET_H

#include <string>
#include <vector>
#include <boost/shared_ptr.hpp>
#include <boost/thread.hpp>
#include <sl/class_loader/register.hpp>
#include <servlet/http/HttpServlet.h>

#include "JspContext.h"
#include "JspLoader.h"

namespace modules {
namespace servlets {

class JspServlet : public servlet::http::HttpServlet {
public :

    void init() throw(servlet::ServletException);

    void destroy() throw();

    void service(servlet::http::HttpServletRequest &,
            servlet::http::HttpServletResponse &)
        throw(servlet::ServletException);

private :
    void doJspCompile(servlet::http::HttpServletRequest &req,
                      servlet::http::HttpServletResponse &res,
                      const std::string &file,
                      const std::string &dir,
                      const std::string &name)
        throw(servlet::ServletException);

    void doUnload(boost::shared_ptr<si::interface::ServletWrapper>& p,
                  const std::string &class_dir,
                  const std::string &class_name);

    si::interface::Context* _context;
    sj::JspContext*                  _jsp_context;
    boost::shared_ptr<sj::JspLoader> _jsp_loader;
    int _debug;

    std::string _CC;
    std::vector<std::string> _options;
    std::vector<std::string> _include;
    std::vector<std::string> _library;
    std::vector<std::string> _shared;
    std::string _context_path;
    std::string _context_name;
    std::string _tempdir_path;

    boost::recursive_mutex _mutex;
};

} // namespace servlets
} // namespace modules

SL_REGIST_LOADABLE_CLASS(modules::servlets::JspServlet)

#endif // SJ_SERVLET_JSP_SERVLET_H
