/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_SERVLET_JSP_CONTEXT_H
#define SJ_SERVLET_JSP_CONTEXT_H

#include <set>
#include <string>
#include <servlet/jsp/JspException.h>

#include <si/interface/Config.h>
#include <si/interface/Context.h>
#include <si/interface/ServletWrapper.h>
#include <si/core/ServletContextImpl.h>
#include <si/webxml/ApplicationConfig.h>

namespace sj {

/**
 * ѥ󥿡ե.
 */
class JspContext : public si::interface::Context {

    typedef std::vector<boost::shared_ptr<si::interface::ServletWrapper> >    wrapper_list_t;

public :
    JspContext();

    // ----- interface::Base -----

    virtual bool operator!() const;

    virtual void config(const si::interface::Config& c);

    virtual si::interface::Config config() const;

    virtual void name(const std::string& name);

    virtual std::string name() const;

    virtual void className(const std::string& name);

    virtual std::string className() const;

    virtual void home(const std::string& home);

    virtual std::string home() const;

    virtual void setParent(si::interface::Base* parent);

    virtual si::interface::Base* getParent() const;

    virtual void setLoader(const boost::shared_ptr<si::interface::Loader>& loader);

    virtual boost::shared_ptr<si::interface::Loader> getLoader() const;

    virtual void setLogger(const boost::shared_ptr<si::interface::Logger>& logger);

    virtual boost::shared_ptr<si::interface::Logger> getLogger() const;

    virtual void setRealm(const boost::shared_ptr<si::interface::Realm>& realm);

    virtual boost::shared_ptr<si::interface::Realm> getRealm() const;

    boost::shared_ptr<si::interface::Logger>
    loadLogger(const si::interface::Config&);

    virtual void init();

    virtual void destroy();

    virtual void service(si::interface::Connection* p);

    // ----- interface::Pipe -----
    // XXXXX
    void setBase(si::interface::Base*)
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

    si::interface::Base* getBase()
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

    void addValve(boost::shared_ptr<si::interface::Valve>&)
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

    void removeValve(boost::shared_ptr<si::interface::Valve>&)
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

    void setValveContext(boost::shared_ptr<si::interface::ValveContext>&)
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

    boost::shared_ptr<si::interface::ValveContext> getValveContext() const
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

    void invoke(si::interface::Connection&)
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

    // ----- interface::Context -----

    virtual void path(const std::string& path);

    virtual std::string path() const;

    virtual void docBase(const std::string& path);

    virtual std::string docBase() const;

    virtual void setWorkDir(const std::string &dir);

    virtual std::string getWorkDir() const;

    virtual bool match(const std::string &uri) const;

    virtual void setManager(const boost::shared_ptr<si::interface::Manager>& manager);

    virtual boost::shared_ptr<si::interface::Manager> getManager() const;

    virtual void setWrapper(boost::shared_ptr<ServletWrapper> wrapper);

    virtual boost::shared_ptr<si::interface::ServletWrapper>
        getWrapper(const std::string &path) const;

    virtual boost::shared_ptr<si::interface::ServletWrapper>
        getNamedWrapper(const std::string& name) const;

    void removeWrapper(const std::string &path);

    virtual servlet::ServletContext& getServletContext();

    time_t invokeTime();

    // ----- XXXXX -----
        void addFilter(boost::shared_ptr<servlet::Filter> filter)
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

        std::vector<boost::shared_ptr<servlet::Filter> > getFilter() const
    {
        throw servlet::jsp::JspException("No Implementation.");
            return std::vector<boost::shared_ptr<servlet::Filter> >();
    }

        servlet::FilterChain& getFilterChain()
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

    std::vector<boost::shared_ptr<sl::java::util::EventListener> >
    getListeners() const
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

    std::vector<si::webxml::security_constraint>
        getSecurityConstraint() const
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

        si::webxml::login_config getLoginConfig() const
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

    si::webxml::session_config getSessionConfig() const
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

    std::list<std::string> welcomeFileList() const
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

    std::string getErrorPage(int) const
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

    std::string getErrorPage(const std::string&) const
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

    si::webxml::jsp_config getJspConfig() const
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

        virtual void addValve(boost::shared_ptr<si::interface::Valve>)
    {
        throw servlet::jsp::JspException("No Implementation.");
    }

        virtual std::vector<boost::shared_ptr<si::interface::Valve> > getValve() const
    {
        throw servlet::jsp::JspException("No Implementation.");
        return std::vector<boost::shared_ptr<si::interface::Valve> >();
    }


    // -----

    virtual void loadManager(const si::interface::Config& c);

private :
    void loadAllWrapper();

    boost::shared_ptr<si::interface::ServletWrapper> loadWrapper();

    bool _available;
    std::string _home;
    std::string _name;
    std::string _class_name;
    std::string _doc_base;
    std::string _path;
    std::string _reloadable;

    si::interface::Config _config;
    boost::shared_ptr<si::interface::Loader> _loader;
    boost::shared_ptr<si::interface::Logger> _logger;
    boost::shared_ptr<si::interface::Manager> _manager;
    boost::shared_ptr<si::interface::Realm> _realm;

    si::webxml::ApplicationConfig* _app_config;
    si::core::ServletContextImpl* _servlet_context;
    wrapper_list_t _wrapper_list;
};

} // namespace sj

#endif // SJ_SERVLET_JSP_CONTEXT_H
