/*-
 * Copyright (c) 2005 osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_EL_OPERATORS_H
#define SJ_EL_OPERATORS_H

#include <stack>
#include <string>
#include <vector>

#include <sl/java/lang/Object.h>
#include <sl/java/lang/String.h>
#include <servlet/jsp/el/FunctionMapper.h>
#include <servlet/jsp/PageContext.h>

namespace sj {
namespace el {

class operators;

namespace op {

typedef sl::java::lang::Object value_type;

/**
 * û黻
 *
 */
struct add
{
    add(operators* parent);

    typedef void result_type;

    void operator()(value_type& lhs, const value_type& rhs) const;
    void operator()(value_type& lhs, const bool rhs) const;
    void operator()(value_type& lhs,
                    const std::string::iterator& first,
                    const std::string::iterator& last) const;
    void operator()(value_type& lhs, char rhs) const;
    void operator()(value_type& lhs, double rhs) const;

private :
        operators*    _parent;
};

struct sub
{
    typedef void result_type;

    void operator()(value_type& lhs, const value_type& rhs) const;
};

struct mul
{
    typedef void result_type;

    void operator()(value_type& lhs, const value_type& rhs) const;
};

struct div
{
    typedef void result_type;

    void operator()(value_type& lhs, const value_type& rhs) const;
};

struct mod
{
    typedef void result_type;

    void operator()(value_type& lhs, const value_type& rhs) const;
};

struct equal
{
    typedef void result_type;

    void operator()(value_type& lhs, const value_type& rhs) const;

    void
    operator()(std::string& lhs, const std::string::iterator& first,
                                 const std::string::iterator& last) const;
};

struct not_equal
{
    typedef void result_type;

    void operator()(value_type& lhs, const value_type& rhs) const;
};

struct less_equal
{
    typedef void result_type;

    void operator()(value_type& lhs, const value_type& rhs) const;
};

struct greater_equal
{
    typedef void result_type;

    void operator()(value_type& lhs, const value_type& rhs) const;
};

struct less
{
    typedef void result_type;

    void operator()(value_type& lhs, const value_type& rhs) const;
};

struct greater
{
    typedef void result_type;

    void operator()(value_type& lhs, const value_type& rhs) const;
};

struct symbol
{
    typedef void result_type;

    symbol(operators* parent, servlet::jsp::PageContext& context);

    void operator()(value_type& lhs, const value_type& rhs) const;
    void operator()(value_type& lhs, const char rhs) const;
    void operator()(value_type& lhs, const std::string::iterator& first,
                                     const std::string::iterator& last) const;

    private :
        operators*    _parent;
        servlet::jsp::PageContext&    _context;
};

struct func
{
    typedef void result_type;

    func(operators* parent, servlet::jsp::PageContext& v);

    void operator()(value_type& lhs, const value_type& rhs) const;
    void operator()(value_type& lhs, const char rhs) const;
    void operator()(value_type& lhs, const std::string::iterator& first,
                                     const std::string::iterator& last) const;

    private :
        operators*    _parent;
        servlet::jsp::PageContext&    _context;
};

struct func_exec
{
    typedef void result_type;

    func_exec(operators* parent,
              servlet::jsp::PageContext& context,
              const servlet::jsp::el::FunctionMapper& mapper);

    void operator()(value_type& lhs, const value_type& rhs) const;

    private :
        operators*    _parent;
        servlet::jsp::PageContext&    _context;
        const servlet::jsp::el::FunctionMapper& _mapper;
};


} // namespace op

typedef std::vector<sl::java::lang::Object>    objects;
typedef std::pair<std::string, objects>    stack_e;

class operators {
public :

    operators(servlet::jsp::PageContext& context,
              const servlet::jsp::el::FunctionMapper& mapper)
        : _context(context),
          _add(const_cast<operators*>(this)),
          _symbol(const_cast<operators*>(this), context),
          _func(const_cast<operators*>(this), context),
          _func_exec(const_cast<operators*>(this), context, mapper)
    { }

private :
    servlet::jsp::PageContext& _context;

public :
    op::equal _eq;
    op::not_equal _not_eq;
    op::less_equal _less_eq;
    op::greater_equal _grtr_eq;
    op::less _less;
    op::greater _grtr;
    op::add _add;
    op::sub _sub;
    op::mul _mul;
    op::div _div;
    op::mod _mod;
    op::symbol _symbol;
    op::func _func;
    op::func_exec _func_exec;

    std::stack<stack_e> _func_stack;
};

} // namespace el
} // namespace sj


#endif // SJ_EL_OPERATORS_H
