/*-
 * Copyright (c) 2005 osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_EL_EL_GRAMMER_H
#define SJ_EL_EL_GRAMMER_H

#ifdef DEBUG
#define BOOST_SPIRIT_DEBUG
#endif
#define BOOST_SPIRIT_THREADSAFE
#include <boost/spirit.hpp>
#include <boost/spirit/phoenix.hpp>
#include <boost/version.hpp>

#if BOOST_VERSION >= 103300
#define BOOST_SPIRIT_NO_REGEX_LIB
#endif
#include <boost/spirit/utility/regex.hpp>

#include "operators.h"

namespace sj {
namespace el {

class el_grammar : public boost::spirit::grammar<el_grammar> {
public :

    struct value_type_closure : boost::spirit::closure<value_type_closure, op::value_type>
    {
        member1 val;
    };

    typedef value_type_closure __closure_type;

    op::value_type& _answer;

    phoenix::functor<op::equal> _eq;
    phoenix::functor<op::not_equal> _ne;
    phoenix::functor<op::less_equal> _le;
    phoenix::functor<op::greater_equal> _ge;
    phoenix::functor<op::less> _lt;
    phoenix::functor<op::greater> _lg;
    phoenix::functor<op::add> _add;
    phoenix::functor<op::sub> _sub;
    phoenix::functor<op::mul> _mul;
    phoenix::functor<op::div> _div;
    phoenix::functor<op::mod> _mod;
    phoenix::functor<op::symbol> _symbol;
    phoenix::functor<op::func> _func;
    phoenix::functor<op::func_exec> _func_exec;

    el_grammar(op::value_type& r, operators& op)
        : _answer(r),
        _eq(op._eq),
        _ne(op._not_eq),
        _le(op._less_eq),
        _ge(op._grtr_eq),
        _lt(op._less),
        _lg(op._grtr),
        _add(op._add),
        _sub(op._sub),
        _mul(op._mul),
        _div(op._div),
        _mod(op._mod),
        _symbol(op._symbol),
        _func(op._func),
        _func_exec(op._func_exec)
    {
    }

    template <typename ScannerT>
    struct definition
    {
        boost::spirit::rule<ScannerT> top;
        boost::spirit::rule<ScannerT, typename __closure_type::context_t>
            expr, sexp, fctr, term, func, sym;

        definition(const el_grammar& self)
        {
                using namespace boost::spirit;
            using phoenix::arg1;
            using phoenix::arg2;

#if BOOST_VERSION >= 103300
            const char *reg("[a-zA-Z_][][a-zA-Z0-9._\\-\" ]+");
            const char *func_reg("[a-zA-Z_][a-zA-Z0-9._]+:[a-zA-Z0-9._]+");
#else
            const char *reg("[a-zA-Z_][\\]\\[a-zA-Z0-9._\\-\" ]+");
            const char *func_reg("[a-zA-Z_][a-zA-Z0-9._]+:[a-zA-Z0-9._]+");
#endif
            top  = expr[ assign_a(self._answer) ];

            expr = sexp[ expr.val = arg1 ] >>
                    !("=="  >> sexp[ self._eq (expr.val, arg1) ]
                    | "!="  >> sexp[ self._ne (expr.val, arg1) ]
                    | "<="  >> sexp[ self._le (expr.val, arg1) ]
                    | ">="  >> sexp[ self._ge (expr.val, arg1) ]
                    | '<'   >> sexp[ self._lt (expr.val, arg1) ]
                    | '>'   >> sexp[ self._lg (expr.val, arg1) ]
                    | "eq"  >> sexp[ self._eq (expr.val, arg1) ]
                    | "ne"  >> sexp[ self._ne (expr.val, arg1) ]
                    | "le"  >> sexp[ self._le (expr.val, arg1) ]
                    | "ge"  >> sexp[ self._ge (expr.val, arg1) ]
                    | "lt"  >> sexp[ self._lt (expr.val, arg1) ]
                    | "lg"  >> sexp[ self._lg (expr.val, arg1) ]
                    );
            sexp = term[ sexp.val = arg1 ] >>
                    *('+'   >> term[ self._add(sexp.val, arg1) ]
                    | '-'   >> term[ self._sub(sexp.val, arg1) ]
                    | "add" >> term[ self._add(sexp.val, arg1) ]
                    | "sub" >> term[ self._sub(sexp.val, arg1) ]
                    );
            term = fctr[ term.val = arg1 ] >>
                    *('*'   >> fctr[ self._mul(term.val, arg1) ]
                    | '/'   >> fctr[ self._div(term.val, arg1) ]
                    | '%'   >> fctr[ self._mod(term.val, arg1) ]
                    | "mul" >> fctr[ self._mul(term.val, arg1) ]
                    | "div" >> fctr[ self._div(term.val, arg1) ]
                    | "mod" >> fctr[ self._mod(term.val, arg1) ]
                    );
            fctr = func[ self._func_exec(fctr.val, arg1) ]
                    | real_p[ self._add(fctr.val, arg1) ]
                    | '(' >> expr[ self._add(fctr.val, arg1) ] >> ')'
                    | comment_p("\"", "\"")[ self._add(fctr.val,arg1,arg2) ]
                    | comment_p("'", "'")  [ self._add(fctr.val,arg1,arg2) ]
                    | regex_p(reg)[ self._symbol(fctr.val, arg1, arg2) ]
                        | eol_p;
                    ;
            func = regex_p(func_reg)[ self._func(func.val, arg1, arg2) ] >>
                    '(' >> expr     [ self._add(func.val, arg1) ] >>
                      *(
                        chset_p(", ")[ self._add(func.val, arg1) ] >>
                        expr         [ self._add(func.val, arg1) ]
                       ) >>
                    ')'
                    ;

    BOOST_SPIRIT_DEBUG_NODE(top);
    BOOST_SPIRIT_DEBUG_NODE(expr);
    BOOST_SPIRIT_DEBUG_NODE(sexp);
    BOOST_SPIRIT_DEBUG_NODE(fctr);
    BOOST_SPIRIT_DEBUG_NODE(term);
    BOOST_SPIRIT_DEBUG_NODE(func);
    BOOST_SPIRIT_DEBUG_NODE(sym);
        }

        const boost::spirit::rule<ScannerT>& start() const { return top; }
    };
};

} // namespace el
} // namespace sj

#endif // SJ_EL_EL_GRAMMER_H
