/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_ENGINE_PAGE_CONTEXT_IMPL_H
#define SJ_ENGINE_PAGE_CONTEXT_IMPL_H

#include <boost/thread/recursive_mutex.hpp>
#include <servlet/jsp/PageContext.h>

namespace sj {

class PageContextImpl : public servlet::jsp::PageContext {
public :

    PageContextImpl();
 
    virtual ~PageContextImpl();

    //
    // JspContext
    //
    virtual sl::java::lang::Object findAttribute(const std::string& name);

    virtual sl::java::lang::Object getAttribute(const std::string& name);

    virtual sl::java::lang::Object
    getAttribute(const std::string& name, int scope);

    virtual sl::java::util::Enumeration getAttributeNamesInScope(int scope);

    virtual int getAttributesScope(const std::string& name);

    virtual servlet::jsp::el::ExpressionEvaluator& getExpressionEvaluator();

    virtual servlet::jsp::JspWriter& getOut();

    virtual servlet::jsp::el::VariableResolver& getVariableResolver();

    virtual servlet::jsp::JspWriter& popBody();
 
    virtual servlet::jsp::JspWriter& pushBody(const sl::java::io::Writer& writer);

    virtual void removeAttribute(const std::string& name);

    virtual void removeAttribute(const std::string& name, int scope);

    virtual void
    setAttribute(const std::string& name, sl::java::lang::Object attribute);

    virtual void
    setAttribute(const std::string& name, sl::java::lang::Object o, int scope);


    //
    // PageContext
    //

    /**
     * RequestDispatcher.forward() ưԤʤޤ.
     */
    virtual void forward(const std::string &url_path);

    /**
     * 㳰֥Ȥθߤ֤ͤޤ.
     */
    virtual std::exception& getException();

    /**
     * ڡ֥(Servlet)θߤ֤ͤޤ.
     */
    virtual sl::java::lang::Object getPage();

    /**
     * ꥯȥ֥(ServletRequest)θߤ֤ͤޤ.
     */
    virtual servlet::ServletRequest& getRequest();

    /**
     * 쥹ݥ󥹥֥(ServletResponse)θߤ֤ͤޤ.
     */
    virtual servlet::ServletResponse& getResponse();

    /**
     * ServletConfigΥ󥹥󥹤֤ޤ
     */
    virtual servlet::ServletConfig& getServletConfig();

    /**
     * ServletContextΥ󥹥󥹤֤ޤ
     */
    virtual servlet::ServletContext& getServletContext();

    /**
     * å󥪥֥ȡHttpSessionˤθߤ֤ͤޤ
     */
    virtual servlet::http::HttpSession& getSession();

    /**
     * Υ᥽åɤϽǤʤ"ڡ"٥㳰
     * JSPѰդƤꤷ顼ڡ
     * 쥯Ȥ뤳ȤˤäƽŪȤƤޤ.
     */
    virtual void handlePageException(std::exception& e);

    /**
     * ꤷ꥽򡢸ƤӽФåɤˤäƽƤ
     * ߤ ServletRequestServletResponseΰȤƽޤ
     */
    virtual void include(const std::string &url_path);

    /**
     * initialize᥽åɤϡƤʤPageContext
     * 뤿˸ƤӽФޤ
     */
    virtual void initialize(servlet::Servlet& s,
                            servlet::ServletRequest& req,
                            servlet::ServletResponse& res,
                            const std::string& error_page_url,
                            bool needs_session,
                            int buffer_size,
                            bool auto_flush);

    /**
     * BodyContent֥Ȥ֤Ƹߤ "out" JspWriter
     * ¸ PageContextΥڡ°֤̾ˤ
     * "out"°ͤ򥢥åץǡȤޤ
     */
    virtual servlet::jsp::tagext::BodyContent& pushBody();

    /**
     * Υ᥽åɤΤ٤ƤλȤinitialize()
     * ƤӽФݤ˺Ѳǽˤ뤿PageContextǡ
     * PageContextξ֤֥ꥻåȡפޤ.
     */
    virtual void release();

private :
    bool    _is_initialize;

    servlet::ServletContext* _servlet_context;
    servlet::ServletConfig* _servlet_config;
    servlet::ServletRequest* _servlet_request;
    servlet::ServletResponse* _servlet_response;
    servlet::http::HttpSession* _session;
    servlet::jsp::JspWriter* _writer;
    std::exception* _exception;

    std::map<std::string, sl::java::lang::Object> _attributes;
    std::set<std::string> _attr_names;
    boost::recursive_mutex _mutex;

    servlet::jsp::el::ExpressionEvaluator* _expression_evaluator;
    servlet::jsp::el::VariableResolver* _variable_resolver;

    int _push_body_count;
};

} // namespace sj

#endif // SJ_ENGINE_PAGE_CONTEXT_IMPL_H
