/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <map>
#include <string>

#include "JspFactoryImpl.h"
#include "PageContextImpl.h"
using namespace servlet::jsp;
using namespace sj;

//
// Constructor/Destructor
//
JspFactoryImpl::JspFactoryImpl()
{
    setDefaultFactory(*this);
}

JspFactoryImpl::~JspFactoryImpl()
{
}

//
// Member functions.
//

#if 0
JspFactory& JspFactoryImpl::getDefaultFactory()
{
    static JspFactoryImpl _instance;
    return _instance;
}
#endif

JspEngineInfo& JspFactoryImpl::getEngineInfo()
{

}

PageContext& JspFactoryImpl::getPageContext(servlet::Servlet& s,
                                            servlet::ServletRequest& req,
                                            servlet::ServletResponse& res,
                                            std::string error_page_url,
                                            bool needs_session,
                                            int buffer,
                                            bool auto_flush)
{
    PageContext* page = new PageContextImpl();
    page->initialize(s, req, res, error_page_url, needs_session, buffer, auto_flush);
    _pages.insert(page);
    return *page;
}

void JspFactoryImpl::releasePageContext(PageContext& page)
{
    _pages.erase(&page);
}
