/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <string>
using namespace std;

#include <boost/algorithm/string/trim.hpp>
#include <boost/algorithm/string/classification.hpp>
using namespace boost;

#include <sl/object.hpp>
#include <sl/java/lang/Object.h>
#include <servlet/jsp/PageContext.h>
using namespace sl::java::lang;
using namespace servlet::jsp;
using namespace servlet::jsp::el;

#include "ExpressionEvaluatorImpl.h"
#include "ExpressionImpl.h"
#include "el/parser.h"
using namespace sj;


ExpressionEvaluatorImpl::ExpressionEvaluatorImpl(PageContext& context)
    : _context(context)
{
}

ExpressionEvaluatorImpl::~ExpressionEvaluatorImpl()
{
}


Object ExpressionEvaluatorImpl::evaluate(const string& expression,
                                         const Class& type,
                                         const VariableResolver& resolver,
                                         const FunctionMapper& mapper)
    throw (ELException)
{
#ifdef DEBUG
    cerr << "ExpressionEvaluatorImpl::evaluate: [" << expression << "]" << endl;
#endif

    if (expression.empty())
        return Object();

    std::string exp(expression);

    if (expression[0] == '$') {
        if (expression[1] != '{' || expression[expression.length() - 1] != '}')
        {
            throw servlet::jsp::el::ELException("sj::ExpressionEvaluator. "
                                                "Invalid EL format.");
            return Object();
        }
        exp.erase(0, 2);
        exp.erase(exp.length() -1);
    }

    sl::java::lang::Object obj;
    try {
        el::parser parser;
        obj = parser.start(_context, mapper, exp);

        /* ͤμºݤη std::string ʳξȤƤ */
        if (!obj.instanceof<std::string>())
            throw servlet::jsp::el::ELException("sj::ExpressionEvaluator. "
                                                "result is not std::string.");
    } catch (std::exception& e) {
        throw servlet::jsp::el::ELException("sj::ExpressionEvaluator. "
                                            "parse failed. expression:" + exp);
    }
#ifdef DEBUG
    if (obj) {
        try {
            std::string s = sl::object_cast<std::string>(obj);
            std::cerr << "result [" << s << "]" << std::endl;
        } catch (std::exception& e) {
            std::cerr << e.what() << std::endl;
        }
    } else
        std::cerr << "result is NULL" << std::endl;

    std::cerr << "ExpressionEvaluatorImpl::evaluate: success" << std::endl;
#endif
    return obj;
}

auto_ptr<Expression>
ExpressionEvaluatorImpl::parseExpression(const string& expression,
                                         const Class& type,
                                         const FunctionMapper& fMapper)
    throw (ELParseException)
{
    return auto_ptr<Expression>(new ExpressionImpl());
}
