/*-
 * Copyright (c) 2005 osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_COMPILER_TLD_TAG_H
#define SJ_COMPILER_TLD_TAG_H

#include <iostream>
#include <map>
#include <set>
#include <string>
#include <boost/algorithm/string/replace.hpp>

namespace sj {

typedef std::map<std::string, std::string> string_map_t;

/**
 * дؿξݻ뤿 map .
 * ƥץ졼Ȱ 1 ؿ̾ 2 η̾Υꥹ.
 *
 * ͤϺΤȤפʤΤ̵.
 */
typedef std::map<std::string, std::vector<std::string> > functions_map_t;

/**
 * @tld_tag.
 *
 * JSP եθġΥॿФƤξݻ륯饹Ǥ.
 * 
 * JSP եǤεҤƤ̾°ȶ
 * TLD ե˵Ҥ <tag> ǰʲΥƥ
 * 饹ݻޤ.
 */
class tld_tag {
public :

    std::string root() const
    {
        return _root;
    }

    std::string prefix() const
    {
        return _prefix;
    }

    std::string name() const
    {
        return _name;
    }

    std::string tag_class() const
    {
        return _tag_class;
    }

    std::string tag_class_name() const
    {
        std::string::size_type pos = _tag_class.rfind("/");
        if (pos != std::string::npos)
            return _tag_class.substr(pos + 1);
        return _tag_class;
    }

    std::string tei_class() const
    {
        return _tei_class;
    }

    std::string body_content() const
    {
        return _body_content;
    }

    string_map_t attributes() const
    {
        return _attributes;
    }

    std::string attribute(const std::string& name) const
    {
        string_map_t::const_iterator i = _attributes.find(name);
        return i != _attributes.end() ? i->second : "";
    }

    std::set<std::string> base_classes() const
    {
        return _base_classes;
    }

    functions_map_t functions() const
    {
        return _functions;
    }

    void root(const std::string& s)
    {
        _root = s;
    }

    void prefix(const std::string& s)
    {
        _prefix = s;
    }

    void name(const std::string& s)
    {
        _name = s;
    }

    void tag_class(const std::string& s)
    {
        _tag_class = s;
        boost::replace_all(_tag_class, ".", "/");
    }

    void tei_class(const std::string& s)
    {
        _tei_class = s;
        boost::replace_all(_tei_class, ".", "/");
    }

    void body_content(const std::string& s)
    {
        _body_content = s;
    }

    void attributes(string_map_t& attr)
    {
        _attributes = attr;
    }

    void base_classes(const std::set<std::string>& classes)
    {
        _base_classes = classes;
    }

    void functions(const functions_map_t& functions)
    {
        _functions = functions;
    }

    void debug_dump() const
    {
        std::cout << "----- tag configuration -----" << std::endl;
        std::cout << "prefix :" << _prefix << std::endl;
        std::cout << "name :" << _name << std::endl;
        std::cout << "class:" << _tag_class << std::endl;
        std::cout << "extra:" << _tei_class << std::endl;
        std::cout << "body :" << _body_content << std::endl;

        string_map_t::const_iterator a = _attributes.begin();
        for (; a != _attributes.end(); a++)
            std::cout << "attr :" << a->first << ":" << a->second << std::endl;
    }

private :
    std::string _root;
    std::string _prefix;
    std::string _name;
    std::string _tag_class;
    std::string _tei_class;
    std::string _body_content;
    string_map_t _attributes;
    std::set<std::string> _base_classes;
    functions_map_t _functions;
};

inline bool operator<(const tld_tag& l, const tld_tag& r)
{
    return (l.prefix() + l.name()) < (r.prefix() + r.name());
}

} // namespace sj

#endif // SJ_COMPILER_TLD_TAG_H
