/*-
 * Copyright (c) 2005 osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_COMPILER_TLD_PERSER_H
#define SJ_COMPILER_TLD_PERSER_H

#include <map>
#include <list>
#include <string>

#include "tld_tag.h"
#include "tld_function.h"

namespace sj {

/**
 * @class tld_parser.
 *
 * JSP Ƥ TLD ե򤹤٤ɤ߹ tld_tag 
 * tld_function 饹ηݻ륯饹Ǥ.
 *
 */
class tld_parser {
    typedef std::map<std::string, std::list<tld_tag> >    tag_map_t;
    typedef std::map<std::string, std::string>            string_map_t;

public :

    /**
     * TLD ɤ߹ߤ򳫻Ϥޤ.
     *
     * @param    home    WEBƥʤΥۡǥ쥯ȥ.
     * @param    root    WEBץꥱΥ롼ȥǥ쥯ȥ.
     * @param    taguri    web.xml ե˵ҤƤ taglib .
     * @param    urimap    JSPե˵ҤƤ taglib ǥ쥯ƥ.
     * @return    TLD ɤ߹߷.
     */
    bool start(const std::string& home,
               const std::string& root,
               const string_map_t& taguri,
               const string_map_t& urimap,
               bool debug=false);

    std::list<tld_tag> tld_tags(const std::string& uri) const;
    std::list<tld_tag> tld_tags() const;
    std::list<tld_function> tld_functions() const;

private :
    tag_map_t _tag_map;

    bool parse_tld(const std::string& root,
                   const std::string& prefix,
                   const std::string& file);

    std::list<tld_tag> parse_tag_list() const;
    std::list<tld_function> parse_func_list() const;

    std::list<tld_tag> _tag_list;
    std::list<tld_function> _func_list;
};

} // namespace sj


#endif // SJ_COMPILER_TLD_PERSER_H
