/*-
 * Copyright (c) 2005 osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_COMPILER_TAG_CLASS_PARSER_H
#define SJ_COMPILER_TAG_CLASS_PARSER_H

#include <map>
#include <set>
#include <string>
#include <vector>
#include <sl/xml/xml_tag.h>

#include "tld_tag.h"

namespace sj {

/**
 * @class tag_class_parser.
 *
 * ॿΥ饹ɤ߹िΥ饹Ǥ.
 * 
 */
class tag_class_parser {

    typedef std::set<std::string> class_base_map_t;

public :
    /**
     * Constructor.
     *
     * @param    file    ѥޤ Tag 饹
     *                    ե(̾*.h).
     * @param    name    оݤΥ饹̾.
     */
    tag_class_parser(const std::string& file, const std::string& name, bool debug=true);

    /**
     * ѾƤ륯饹Фޤ.
     *
     * @return    饹̾Υꥹ.
     */
    std::set<std::string> base_classes() const;

    /**
     * ꤷдؿΰФޤ.
     * ΥꥹȤϼºݤδؿΰƱˤʤޤ.
     *
     * @param    func    μоݤȤдؿ̾.
     * @return    η̾Υꥹ.
     */
    std::vector<std::string> parameters(const std::string& func) const;

    /**
     * дؿΥꥹȤФޤ.
     * оݤΥ饹ϥ󥹥ȥ饯ǻꤷ饹ˤʤޤ.
     *
     * @return    дؿ̾Υꥹ.
     */
    functions_map_t functions() const;

private :
    sl::xml::xml_tag loop(deque<string> sp, sl::xml::xml_tag& t);

    std::string _class;
    std::set<std::string> _base_classes;
    functions_map_t _functions;
};

} // namespace sj

#endif // SJ_COMPILER_TAG_CLASS_PARSER_H
