/*-
 * Copyright (c) 2005 osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <deque>
#include <iostream>
#include <fstream>
#include <string>
#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>
using namespace std;

#include <sl/xml/class_parser/class_def_parser.h>
#include <sl/xml/xml_parser.h>
using namespace sl::xml;

#include "tag_class_parser.h"
using namespace sj;

tag_class_parser::tag_class_parser(const std::string& file,
                                   const std::string& clazz,
                                   bool debug)
{
    if (debug)
        std::clog << "*** tag_class_parser::tag_class_parser:" << file << endl;

    class_def_parser class_p;
    string class_xml = class_p.start(file);

    deque<string> sp;
    boost::split(sp, clazz, boost::is_any_of("/"));

    string class_name = sp.back();
    sp.pop_back();

    xml_parser xml_p(class_xml.begin(), class_xml.end());
    xml_tag t = xml_p.get();

    xml_tag final_namespace = loop(sp, t);

    xml_tag class_tag;

    tag_list_t class_tags = final_namespace.get("class");
    tag_list_t::iterator i = class_tags.begin();
    for (; i != class_tags.end(); i++) {
        if (class_name == i->attr("name")) {
            class_tag = *i;

            tag_list_t base_tags = class_tag.get("base-class");
            tag_list_t::iterator i2 = base_tags.begin();
            for (; i2 != base_tags.end(); i2++)
                _base_classes.insert(i2->attr("name"));
        }
    }

    tag_list_t func_tags = class_tag.get("function");
    tag_list_t::iterator i2 = func_tags.begin();

    for (; i2 != func_tags.end(); i2++) {
        vector<string> params;

        tag_list_t arg_tags = i2->get("arg");
        tag_list_t::iterator i3 = arg_tags.begin();
        for (; i3 != arg_tags.end(); i3++) {
            params.push_back(i3->value());
        }

        _functions.insert(make_pair(i2->attr("name"), params));
    }
    if (debug)
        std::clog << "*** tag_class_parser::tag_class_parser Exit" << endl;
}

xml_tag tag_class_parser::loop(deque<string> sp, xml_tag& t)
{
    xml_tag last;

    deque<string>::iterator i = sp.begin();
    for (; i != sp.end(); i++) {
        tag_list_t namespaces = t.get("namespace");
        tag_list_t::iterator j = namespaces.begin();
        for (; j != namespaces.end(); j++) {
            if (*i == j->attr("name"))
                sp.erase(sp.begin(), i);
                last = loop(sp, *j);
                if (!last)
                    return *j;
        }
    }
    return last;
}

set<string> tag_class_parser::base_classes() const
{
    return _base_classes;
}

vector<string> tag_class_parser::parameters(const std::string& func) const
{
    functions_map_t::const_iterator i = _functions.find(func);
    if (i != _functions.end())
        return i->second;
    return vector<string>();
}

functions_map_t tag_class_parser::functions() const
{
    return _functions;
}
