/*-
 * Copyright (c) 2005 osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_COMPILER_JSP_PARSER_H
#define SJ_COMPILER_JSP_PARSER_H

#include <deque>
#include <map>
#include <vector>
#include <stdexcept>
#include <string>

#include "jsp_element.h"

namespace sj {

/**
 * @class jsp_parser.
 * JSP եβϽĥ饹Ǥ.
 * 
 *
 */
class jsp_parser {
public :
    typedef std::map<std::string, std::string>    string_map_t;
    typedef std::deque<std::string>                file_t;

    /**
     *  jsp_file ФƲϽ¹Ԥޤ.
     * 
     * @param    jsp_file    JSPեΥƥ. 
     * @return    ¹Է  true
     *                     ۾ false
     */
    bool start(const std::string& jsp_file);

    /**
     * Ϸ̤֤ޤ.
     * start ؿ¹Ԥޤ start ؿԤƤ֤
     * δؿ¹Ԥ㳰ȯޤ.
     * 
     * @return    Ϸ̤Υ롼Ȥ jsp_element_ptr.
     * @throw    ˲ϽλƤʤ֤ǤθƤӽФȯޤ.
     */
    jsp_element_ptr result() throw(std::runtime_error);

    /**
     *  e ΥڤӤ۲ΥͥȤ줿Ρɤɤ߹ߡ
     * `taglib' ǥ쥯ƥ֤° "uri" ꥹȤˤ֤ޤ.
     *
     * @param    e    åоݤ jsp_element_ptr.
     */
    std::vector<std::string> taguri_list(jsp_element_ptr e);

    /**
     *  e ΥڤӤ۲ΥͥȤ줿Ρɤɤ߹ߡ
     * `taglib' ǥ쥯ƥ֤° "prefix"  "uri" 
     * ޥåפˤ֤ޤ.
     *
     * @param    e    åоݤ jsp_element_ptr.
     */
    string_map_t taguri_map(jsp_element_ptr e);

    /**
     *  uri ˥ޥå prefix ֤ޤ.
     * ¸ߤʤ϶ʸ֤ޤ.
     *
     * @param    uri    оݤ uri.
     */
    std::string prefix(const std::string& uri) const;

private :
    bool parse(file_t& file, jsp_element_ptr e);

    int parse_prefix(jsp_element_ptr e,
                    file_t& file,
                    const std::string& s);

    int parse_expression(jsp_element_ptr e,
                    file_t& file,
                    const std::string& s);

    int parse_declaration(jsp_element_ptr e,
                    file_t& file,
                     const std::string& s);

    int parse_scriptlet(jsp_element_ptr e,
                    file_t& file,
                    const std::string& s);

    int parse_directive(jsp_element_ptr e,
                    file_t& file,
                    const std::string& s);

    void parse_action(jsp_element_ptr e,
                    file_t& file,
                    const std::string& s);

    void erase_action(file_t& file, const std::string& s);

    bool split_attribute(std::string& s,
                         std::pair<std::string, std::string>& p);

    void release(jsp_element_ptr e);

    std::string find_prefix(const jsp_element_ptr e,
                            const std::string& uri) const;

    void debug_dump(const jsp_element_ptr& e, int);

    std::vector<std::string> _prefix;
    jsp_element_ptr _jsp_element;
};

} // namespace sj


#endif // SJ_COMPILER_JSP_PARSER_H
