/*-
 * Copyright (c) 2005 osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_COMPILER_JSP_ELEMENT_H
#define SJ_COMPILER_JSP_ELEMENT_H

#include <string>
#include <vector>
#include <map>
#include <boost/shared_ptr.hpp>

namespace sj {

/**
 * JSP γǤǤ jsp_element ФʬȤƻѤǤ.
 */
enum jsp_element_type {
    normal,
    expression,
    declaration,
    scriptlet,
    directive,
    action,
    jsp_std_action
};


class jsp_element;
typedef boost::shared_ptr<jsp_element> jsp_element_ptr;

/**
 * @class jsp_element.
 * JSP γƥǡޤ JSP ե¸ߤ `̤ι' 
 * ݻ륯饹Ǥ.
 *
 * Υ饹 jsp_parser ˤäꤵ륯饹Ǥꡢ
 * μ̤°ͤݻޤ.
 * 
 * JSP ե XML Ʊͤ˥ĥ꡼¤Υ֤ȤʤΤ
 * jsp_element 饹Ʊͤ˥ͥȤǤ jsp_element 
 * ݥ󥿤Ȥݻޤ.
 */
class jsp_element {
public :
    /** Constructor. */
    jsp_element() { }

    /**
     * ǤμѤꤷޤ.
     * @param    s    Ѥ jsp_element_type.
     */
    void type(jsp_element_type e)
    {
        _type = e;
    }

    /**
     * ºݤ˵ҤƤʸꤷޤ.
     * δؿɤ߹Ԥ JSP ޤޤʤ̾ιԤξ˻Ѥޤ.
     *
     * @param    s    Ԥʸ.
     */
    void line(const std::string& s)
    {
        _line = s;
    }

    /**
     * JSP Ǥ prefix ʬݻ뤿δؿǤ.
     * 
     * @param    s     prefix 򼨤ʸ.
     */
    void prefix(const std::string& s)
    {
        _prefix = s;
    }

    /**
     * JSP Ǥ action ʬݻ뤿δؿǤ.
     * 
     * @param    s     action 򼨤ʸ.
     */
    void action(const std::string& s)
    {
        _action = s;
    }

    /**
     * ͥȤǤ򼫿Ȥ۲ΥΡɤȤ¸ޤ.
     *
     * @param    e    ۲ΥΡɤ򼨤 jsp_element Υݥ.
     */
    void push_back(jsp_element_ptr e)
    {
        _jsp_elements.push_back(e);
    }

    /**
     * ǤμѤ֤ޤ.
     * @return    Ѥ jsp_element_type.
     */
    jsp_element_type type() const
    {
        return _type;
    }

    /**
     *  jsp_element ݻǤ '̾ι'ξ
     *  `JSP ޤޤʤ̾ι' ֤ޤ.
     *
     * @return    Ԥʸ.
     */
    std::string line() const
    {
        return _line;
    }

    /**
     * JSP Ǥ prefix ʬ֤ޤ.
     *  jsp_element ݻǤ JSP Ǥʤ
     * ʸ֤ޤ.
     * 
     * @return     prefix 򼨤ʸ.
     */
    std::string prefix() const
    {
        return _prefix;
    }

    /**
     * JSP Ǥ action ʬ֤ޤ.
     *  jsp_element ݻǤ JSP Ǥʤ
     * ʸ֤ޤ.
     * 
     * @return     action 򼨤ʸ.
     */
    std::string action() const
    {
        return _action;
    }

    /**
     *  jsp_element ݻ륿ǤΥͥȤ
     * ۲ΥǤޤ jsp_element Υݥ󥿤ΥꥹȤ֤ޤ.
     * 
     * @return    ͥȤ۲Ǥؤ jsp_element  vector. 
     */
    std::vector<jsp_element_ptr> jsp_elements() const
    {
        return _jsp_elements;
    }

    /**
     *  jsp_element ݻ륿Ǥ°ꤵƤͤ
     * ݻ뤿Υޥåץ饹Ǥ.
     * 
     * ݤäΤǥѿľܸǤ.
     */
    std::map<std::string, std::string> attribute;

private :
    jsp_element_type _type;
    std::string _prefix;
    std::string _action;
    std::string _line;

    std::vector<jsp_element_ptr> _jsp_elements;
};

} // namespace jsp

#endif // SJ_COMPILER_JSP_ELEMENT_H
