/*-
 * Copyright (c) 2005 osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_COMPILER_JSP_COMPILER_H
#define SJ_COMPILER_JSP_COMPILER_H

#include <map>
#include <set>
#include <string>
#include <vector>

namespace sj {

/**
 * @class jsp_compiler.
 * JSPե뤫 Servlet ѥޤǤԤʤ饹Ǥ.
 * 
 *
 */
class jsp_compiler {
public :

    typedef std::vector<std::string>            options_t;
    typedef std::map<std::string, std::string>    string_map_t;

    /**
     * JSP եФ Servlet ѤΥԤʤޤ.
     *
     * @param    home    jsp_compiler ưƤ륳ƥʤ
     *                   ۡǥ쥯ȥ.
     * @param    file    JSP ե.
     *                   WEBץꥱΥ롼ȥǥ쥯ȥ꤫
     *                   Хѥꤷޤ.
     * @param    context_root    ΥѥԤʤWEBץꥱ
     *                    롼ȥǥ쥯ȥ.
     * @param    output   ΥѥԤʤä̤Ȥ
     *                    ɤγǼǥ쥯ȥ.
     *                    WEBץꥱΥ롼ȥǥ쥯ȥ꤫
     *                    Хѥꤷޤ.
     * @param    targuri  web.xml  taginfo ˵ҤƤ
     *                    ̾ URI Υޥå.
     * @param    CC       ǵư C++ ѤΥѥ.
     * @param    opt      ǵư c++ ѤΥѥϤ
     *                    ץ.
     * @param    inc      ǵư c++ ѤΥѥϤ
     *                    󥯥롼ɥѥ.
     * @param    lib      ǵư c++ ѤΥѥϤ
     *                    饤֥ѥ.
     * @param    shared   ǵư c++ ѤΥѥϤ
     *                    ץ.
     * @param    dep_libs JSP եϤ˷ꤷ Servlet 
     *                    ɬפȤ륷ɥ饤֥.
     *
     * @return    ¹Է̤Ǥꡢ true ǤfalseǤ
     *            ʤ餫ΰ۾ȯ򼨤.
     */
    bool run(const std::string& home,
             const std::string& context_root,
             const std::string& file,
             const std::string& output,
             const string_map_t& taguri,
             const std::string& CC,
             const options_t& opt,
             const options_t& inc, 
             const options_t& lib,
             const options_t& shared,
             std::set<std::string>& dep_libs,
             bool debug=false);
};

} // namespace sj

#endif // SJ_COMPILER_JSP_COMPILER_H
