#include <unistd.h>
#include <iostream>
#include <sl/config.hpp>

#include "jsp2c/jsp_compiler.h"
#include "jsp2c/util.h"

void usage()
{
    std::cerr << "Usage: jsp2c [option] jsp-file" << std::endl;
    std::cerr << "  -o <dir>  줿ServletνΥǥ쥯ȥ̾" << std::endl;
    std::cerr << "  -r <path> jspեƤ륳ƥȤΥ롼ȥǥ쥯ȥ" << std::endl;
    std::cerr << "  -I<path>  줿ServletѥΥ󥯥롼ɥѥ" << std::endl;
    std::cerr << "  -L<path>  줿ServletѥΥ饤֥ѥ" << std::endl;
    std::cerr << "  -l<name>  줿Servlet󥯻Υ饤֥" << std::endl;
    std::cerr << "  -v        ǥХåѥåϤޤ" << std::endl;
    std::cerr << "  -T <URI>:<TLD> jspեΥURIȤtldեѥꤷޤ" << std::endl;

    exit(1);
}

int main(int argc, char** argv)
{
    std::string root;
    std::string output = "jsp_out";
    std::string jsp_config_xml;
    sj::jsp_compiler::options_t incdirs;
    sj::jsp_compiler::options_t libdirs;
    sj::jsp_compiler::options_t options;
    sj::jsp_compiler::options_t linklibs;

    /* URL */
    sj::jsp_compiler::string_map_t taguri;

    bool debug = false;

    options.push_back("-shared");

    int ch;
    while ((ch = ::getopt(argc, argv, "dho:r:I:L:l:T:")) != -1) {
        switch (ch) {
        case 'o':
            output = optarg;
            break;
        case 'r':
            root = optarg;
            break;
        case 'I':
            incdirs.push_back(optarg);
            break;
        case 'L':
            libdirs.push_back(optarg);
            break;
        case 'T':
            {
            std::string arg(optarg);
            std::string::size_type pos;
            if ((pos = arg.find(':')) == std::string::npos) {
                std::cerr << "-T ץͤǤ" << std::endl;
                exit(1);
            }
            std::string uri = arg.substr(0, pos);
            std::string tld = arg.substr(pos + 1);
            taguri.insert(std::make_pair(uri, tld));
            }
            break;
        case 'l':
            linklibs.push_back(std::string("-l") + optarg);
            break;
        case 'd':
            debug = true;
        case '?':
            if (optarg)
                options.push_back(optarg);
            break;
        default:
            std::cerr << "Illegal option:" << ch << std::endl;
        case 'h':
            usage();
        }
    }
    argc -= optind;
    argv += optind;

    if (argc != 1) usage();

    std::string jsp_file(*argv);

    std::string::size_type pos;
    if ((pos = jsp_file.rfind('/')) != std::string::npos)
        output += "/" + jsp_file.substr(0, pos);

    std::set<std::string> deplibs;

    try {
        sj::jsp_compiler jsp2c;
        jsp2c.run(".",
                  root,
                  jsp_file,
                  output,
                  taguri,
                  sl::config::compiler,
                  options,
                  incdirs,
                  libdirs,
                  linklibs,
                  deplibs,
                  debug);
    } catch (std::exception& e) {
        std::cerr << "*** " << e.what() << std::endl;
        exit(1);
    }
    return 0;
}
