/*-
 * Copyright (c) 2005 osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_COMPILER_GENERATOR_H
#define SJ_COMPILER_GENERATOR_H

#include <map>
#include <list>
#include <string>
#include <stack>

#include "file_type.h"
#include "jsp_element.h"
#include "tld_tag.h"
#include "tld_function.h"

namespace sj {

/**
 * @class generator.
 *
 * JSP βϷ̤ TLD եβϷ̤
 * Servlet 饹륯饹.
 * 
 * 륽ˤ إåե(*.h) ȥե(*.cpp)  
 * եˤϻѤƤ Tag 饹 EL  Functions  
 * ޤޤޤ.
 * 
 * 
 */
class generator {
    typedef std::list<tld_tag> tag_list_t;
    typedef std::list<tld_function> func_list_t;
    typedef std::map<std::string, std::string> string_map_t;

public :
    /** Constructor. */
    generator();

    /**
     * γϴؿ.
     *
     * @param    class_name  JSP ǥɤ Servlet 饹̾.
     * @param    root        оݤȤʤ JSP ե֤
     *                       ƥȥ롼ȤΥǥ쥯ȥ.
     * @param    output_dir  ե롢إåեν
     *                       Ȥʤǥ쥯ȥ.
     * @param    jsp_element_root JSP եϤ̾ݻ
     *                             jsp_element_ptr .
     * @param    tld_tags    TLD եϤ̤Τ
     *                       Tag 饹Ϣξݻ tld_tag 饹
     *                       ꥹ.
     * @param    tld_functions    TLD եϤ̤Τ
     *                            EL Function ǽξݻ
     *                            tld_function Υꥹ.
     * @return    η  true    .
     *                              false    ۾ȯˤ꥽. 
     */
    bool start(const std::string& class_name,
               const std::string& name_space,
               const std::string& root,
               const std::string& output_dir,
               const jsp_element_ptr& jsp_element_root,
               const tag_list_t& tld_tags,
               const func_list_t& tld_functions,
               bool debug=false);

private :
    void header_begin();
    void header_end();

    void default_include();
    void depend_classes();
    void init();
    void destroy();
    void service();
    void service(const std::vector<jsp_element_ptr>& e);

    void select_process(const std::vector<jsp_element_ptr>& e,
                        file_type& out);

    void normal_line(file_type& out, const std::string& line);
    void tag_action(const jsp_element_ptr& e, file_type& out);
    void jsp_action(const jsp_element_ptr& e, file_type& out);
    void simple_tag_body(const std::string&,
                         const std::string&,
                         const jsp_element_ptr& e);
    void page_directive(const jsp_element_ptr& e, file_type& out);

    void output(const std::string& output_dir);
    void debug_dump();

    void function_mapper(file_type& f);

    /**
     * EL ʸ.
     * 
     * @param    el    ELʸ.
     * @return     ELθƽФʸ.
     */
    std::string el_expression(const std::string& el);

    /**
     * Tag 饹 setter Фʸ.
     * 
     * @param    ʸ (EL) ʸ.
     * @param    setter    ͤǤ setter δؿ̾.
     * @param    tag        оݤ Tag 饹ξݻ tld_tag.
     * @return    ʸ.
     */
    std::string attribute_arg(const std::string& line,
                              const std::string& setter,
                              tld_tag& tag);

    void attribute_setter(const std::string& tag_name,
                            const jsp_element_ptr& e,
                            const tld_tag& tag,
                            file_type& f);

    std::string _name_space;
    std::string _name_space_begin;
    std::string _name_space_end;
    std::string _class_name;
    file_type _depend;
    file_type _import;
    std::vector<file_type> _header_file;
    std::vector<file_type> _source_file;

    tag_list_t _tags;
    func_list_t _tld_functions;

    std::map<std::string, int> _unique_prefix_count;
    std::stack<std::string> _current_tag;
    bool _debug;
};

} // namespace sj

#endif // SJ_COMPILER_GENERATOR_H
