/*-
 * Copyright (c) 2005 osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_COMPILE_FILE_TYPE_H
#define SJ_COMPILE_FILE_TYPE_H

#include <iostream>
#include <iterator>
#include <deque>
#include <string>

namespace sj {

/**
 * @class file_type.
 *
 * generator 饹ǻѤ륽եΥХåե󥰤
 * Ԥʤ饹Ǥ.
 */
class file_type {
    enum { tab = 4 };

public :
    /** Constructor. */
    file_type() : indent(0) { }

    /**
     * ȤإХåե󥰤뤿 operator<<ؿ.
     *
     * @param    line    񤭹ʸ.
     * @return    񤭹߸ file_type 󥹥.
     */
    file_type &operator<<(const std::string& line)
    {
        this->push_back(line);
        return *this;
    }

    /**
     * 񤭹ߥХåեؤΥƥ졼֤ޤ.
     *
     * @return    ƹԤؤΥƥ졼.
     */
    std::deque<std::string>::iterator begin()
    {
        return _queue.begin();
    }

    /**
     * 񤭹ߥХåեؤΥƥ졼֤ޤ.
     *
     * @return    ƹԤؤΥƥ졼.
     */
    std::deque<std::string>::const_iterator begin() const
    {
        return _queue.begin();
    }

    /**
     * 񤭹ߥХåեؤΥƥ졼֤ޤ.
     *
     * @return    ƹԤؤΥƥ졼.
     */
    std::deque<std::string>::iterator end()
    {
        return _queue.end();
    }

    /**
     * 񤭹ߥХåեؤΥƥ졼֤ޤ.
     *
     * @return    ƹԤؤΥƥ졼.
     */
    std::deque<std::string>::const_iterator end() const
    {
        return _queue.end();
    }

    /**
     * ȤإХåե󥰤뤿δؿ.
     *
     * @param    line    񤭹ʸ.
     * @return    񤭹߸ file_type 󥹥.
     */
    void push_back(const std::string& line)
    {
        _queue.push_back(std::string(indent * tab, ' ') + (!line.empty() ? line : ""));
    }

    /**
     * Хåեƺޤ.
     */
    void clear()
    {
        _queue.clear();
    }

    /**
     * 񤭹ԤΥǥȤݻޤ.
     * 1󥯥Ȥ 4Ĥζ򤬹ԤƬ˼ưޤ.
     */
    int indent;

private :
    std::deque<std::string> _queue;
};


/**
 * ȥ꡼ؤνѤΥڥ졼.
 * 
 * @param    os    Υȥ꡼.
 * @param    f    ϥХåեݻ file_type 󥹥.
 * @return    Υȥ꡼.
 */
inline std::ostream& operator<<(std::ostream& os, const file_type& f)
{
    std::copy(f.begin(), f.end(), std::ostream_iterator<std::string>(os, "\n"));
    return os;
}

} // namespace sj


#endif // SJ_COMPILE_FILE_TYPE_H
