/*
 * make
 * ./a.out sample.jsp /usr/home/test/prog/shibainu/webapps/scriptlet work
 *
 * $Id: main.cpp,v 1.2 2007/08/18 15:43:10 cvsuser Exp $
 */

#include <iostream>
#include <map>
#include <set>
#include <string>
using namespace std;

#include "jsp_compiler.h"
#include "util/util.h"
using namespace sj;

int main(int argc, char** argv)
{
	if (argc < 4) {
		cerr << "invalid argument" << endl;
		cerr << "usage :" << argv[0] << " JSP_FILE WEBAPP_ROOT OUTPUT_DIR"
				  << endl;
		exit(1);
	}
	string jsp_file = argv[1];
	string root_dir = argv[2];
	string output_dir = argv[3];

	map<string, string> tag_uri;

	tag_uri.insert(make_pair("http://java.sun.com/jsp/jstl/core",
					"/WEB-INF/jsp/taglib.tld"));
	tag_uri.insert(make_pair("http://jakarta.apache.org/tomcat/examples-taglib",
					"/WEB-INF/jsp/examples-taglib.tld"));
	tag_uri.insert(make_pair("http://jakarta.apache.org/tomcat/debug-taglib",
					"/WEB-INF/jsp/debug-taglib.tld"));
	tag_uri.insert(make_pair("http://www.j2cc.org/taglib",
					"/WEB-INF/jsp/taglib.tld"));
	tag_uri.insert(make_pair("http://www.j2cc.org/taglib2",
					"/WEB-INF/jsp/taglib2.tld"));

	set<string> opt;
	set<string> inc;
	set<string> lib;
	set<string> shared;
	set<string> dep_libs;

	opt.insert("-O2");
	opt.insert("-Wall");
	opt.insert("-shared");
	inc.insert(root_dir + "/WEB-INF/classes");
	inc.insert("/usr/local/include");
	inc.insert("/usr/local/include/sl");
	inc.insert("/usr/local/include/servlet");
	inc.insert("/usr/local/include/boost-1_33_1");
	lib.insert("/usr/local/lib");
	shared.insert("libjsp-api.so");
	shared.insert("libservlet-api.so");

	jsp_compiler jcc;
	jcc.run("./",			// home directory
			jsp_file,
			root_dir,
			output_dir,
			tag_uri,
			opt,
			inc,
			lib,
			shared,
			dep_libs);

	return 0;
}
