/*-
 * Copyright (c) 2005 osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SJ_COMPILER_CONPILER_H
#define SJ_COMPILER_CONPILER_H

#include <string>
#include <vector>
#include <stdexcept>

namespace sj {

    class compile_error : public std::runtime_error {
    public :
        compile_error(const std::string& s) : std::runtime_error(s) { }
        const char* what() throw() { return std::runtime_error::what(); }
    };

class compiler {
public :
    /**
     * Constructor.
     * ѥоݤΥե target Ƚϥե̾ output ꤷޤ.
     * 
     * @param    path    ѥоݤΥեѥ.
     * @param    file    ѥоݤΥե̾.
     * @param    output    ϥե̾.
     */
    compiler(const std::string& path,
             const std::string& file,
             const std::string& output="a.out");

    /** Destructor. */
    virtual ~compiler() {}

    /**
     * ƥ˥󥹥ȡ뤵Ƥ륳ѥ̾ꤷޤ.
     * @param    cc    ѥ̾.
     */
    void system_compiler(const std::string& cc);

    /**
     * ѥоݤΥեɲäޤ.
     * @param    file    ե̾.
     */
    void add_file(const std::string& file);

    /**
     * ѥΥ󥯥롼ɥǥ쥯ȥɲäޤ.
     * @param    dir    ǥ쥯ȥ̾.
     */
    void add_include(const std::string& dir);

    /**
     * ѥΥ饤֥ǥ쥯ȥɲäޤ.
     * @param    dir    ǥ쥯ȥ̾.
     */
    void add_library(const std::string& dir);

    /**
     * ѥΥ󥯥饤֥ɲäޤ.
     * @param    input    饤֥̾.
     */
    void add_shared(const std::string& input);

    /**
     * ѥΥ֥ȥեɲäޤ.
     * @param    file    ֥ȥե̾.
     */
    void add_object(const std::string& file);

    /**
     * ѥΰץɲäޤ.
     * @param    opt    ץ.
     */
    void add_option(const std::string& opt);

    /**
     * ѥΥ󥫡ѥץɲäޤ.
     * @param    opt    ץ.
     */
    void add_ld_option(const std::string& opt);

    /**
     * ѥоݤΥե̾ѹޤ.
     * add_file() ˤäɲä줿ե̾ѹޤ.
     *
     * @param    target    ѥоݤΥե̾.
     */
    void set_target_file(const std::string& target);

    /**
     * ѥ¹Ԥޤ.
     * 
     * @param    output    ϥե̾.
     */
    virtual void compile(const std::string& output="");

protected:
    std::string _CC;
    std::string _target;
    std::string _output;

private :
    void create_parametor(std::string&);

    void replace_copy(const std::string &, const std::string &);

    std::vector<std::string> _files;
    std::vector<std::string> _options;
    std::vector<std::string> _include;
    std::vector<std::string> _library;
    std::vector<std::string> _shared;
    std::vector<std::string> _objects;
    std::vector<std::string> _ld_options;
};

} // namespace sj

#endif // SJ_COMPILER_CIMPILER_H
