#*-
# Copyright (c) 2008 Masashi Osakabe
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: ax_sl.m4,v 1.8 2008/02/10 09:22:02 cvsuser Exp $
#
#
# --with-sl={directory}
#
# AX_SL([MINIMUM-VERSION], [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# configure.in
#   :AC_SUBST(SL_CPPFLAGS)
#   :AC_SUBST(SL_LDFLAGS)
#
# config.h.in
#   :HAVE_SL
#

AC_DEFUN([AX_SL],
[
	AC_ARG_WITH([sl],
				AS_HELP_STRING([--with-sl=DIR],
				[use sl (default is yes) specify the root directory for shibainu libraries (optional)]),
				[
				if test "$withval" = "no"; then
					want_sl="no"
				elif test "$withval" = "yes"; then
					want_sl="yes"
					ac_sl_path=""
				else
					want_sl="yes"
					ac_sl_path="$withval"
				fi
				],
				[want_sl="yes"])

	if test "x$want_sl" = "xyes"; then
		AX_EXPAT(1.98,, AC_MSG_ERROR([*** Expat 1.98 or higher is required]))
		AX_EXECINFO

		AC_REQUIRE([AC_PROG_CC])
		AC_MSG_CHECKING(for shibainu libraries)

		if test "$ac_sl_path" != ""; then
			SL_LDFLAGS="-L$ac_sl_path/lib"
			SL_CPPFLAGS="-I$ac_sl_path/include"
		else
			for ac_sl_path_tmp in /usr /usr/local /usr/pkg /opt ; do
				if test -d "$ac_sl_path_tmp/include/sl" && test -r "$ac_sl_path_tmp/include/sl"; then
					SL_LDFLAGS="-L$ac_sl_path_tmp/lib"
					SL_CPPFLAGS="-I$ac_sl_path_tmp/include"
					break;
				fi
			done
		fi

		CPPFLAGS="$CPPFLAGS $SL_CPPFLAGS"
		export CPPFLAGS

		LDFLAGS="$LDFLAGS $SL_LDFLAGS"
		export LDFLAGS

		if test "$SL_CPPFLAGS" = "";then
			AC_MSG_RESULT(error)
			AC_MSG_ERROR('shibainu libraries is not exist')
		fi

		AC_MSG_RESULT(yes)

		if ! echo "x$EXPAT_CPPFLAGS" | grep "x$SL_CPPFLAGS" > /dev/null; then
			SL_CPPFLAGS="$SL_CPPFLAGS $EXPAT_CPPFLAGS"
		fi
		if ! echo "x$EXECINFO_CPPFLAGS" | grep "x$SL_CPPFLAGS" > /dev/null; then
			SL_CPPFLAGS="$SL_CPPFLAGS $EXECINFO_CPPFLAGS"
		fi
		if ! echo "x$EXPAT_LDFLAGS" | grep "x$SL_LDFLAGS" > /dev/null; then
			SL_LDFLAGS="$SL_LDFLAGS $EXPAT_LDFLAGS"
		fi
		if ! echo "x$EXECINFO_LDFLAGS" | grep "x$SL_LDFLAGS" > /dev/null; then
			SL_LDFLAGS="$SL_LDFLAGS $EXECINFO_LDFLAGS"
		fi
		AC_SUBST(SL_CPPFLAGS)
		AC_SUBST(SL_LDFLAGS)

		SL_LIBS="-lsi_common -lsl_net -lsl_xml $EXPAT_LIB $EXECINFO_LIB"
		AC_SUBST(SL_LIBS)

		AC_DEFINE(HAVE_SL,,
				[Define to 1 if the shibainu libraries is available])
	fi
])
